/*******************************************************************************


** 


** Filename: SCOFunctions.js


**


** File Description: This file contains several JavaScript functions that are 


**                   used by the Sample SCOs contained in the Sample Course.


**                   These functions encapsulate actions that are taken when the


**                   user navigates between SCOs, or exits the Lesson.


**


** Author: ADL Technical Team


**


** Contract Number:


** Company Name: CTC


**


** Design Issues:


**


** Implementation Issues:


** Known Problems:


** Side Effects:


**


** References: ADL SCORM


**


********************************************************************************


**


** Concurrent Technologies Corporation (CTC) grants you ("Licensee") a non-


** exclusive, royalty free, license to use, modify and redistribute this


** software in source and binary code form, provided that i) this copyright


** notice and license appear on all copies of the software; and ii) Licensee


** does not utilize the software in a manner which is disparaging to CTC.


**


** This software is provided "AS IS," without a warranty of any kind.  ALL


** EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, INCLUDING ANY


** IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NON-


** INFRINGEMENT, ARE HEREBY EXCLUDED.  CTC AND ITS LICENSORS SHALL NOT BE LIABLE


** FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR


** DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES.  IN NO EVENT WILL CTC  OR ITS


** LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT,


** INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER


** CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF


** OR INABILITY TO USE SOFTWARE, EVEN IF CTC  HAS BEEN ADVISED OF THE


** POSSIBILITY OF SUCH DAMAGES.


**


*******************************************************************************/


var startDate;


var exitPageStatus;





function startTimer()


{


   startDate = new Date().getTime();


}





function computeTime()


{


   if ( startDate != 0 )


   {


      var currentDate = new Date().getTime();


      var elapsedSeconds = ( (currentDate - startDate) / 1000 );


      var formattedTime = convertTotalSeconds( elapsedSeconds );


   }


   else


   {


      formattedTime = "00:00:00.0";


   }





   scorm.set( "cmi.session_time", formattedTime );


}





function doBack()


{


   scorm.set( "cmi.core.exit", "suspend" );





   computeTime();


   exitPageStatus = true;


   


   var result;





   result = scorm.Commit();





	// NOTE: LMSFinish will unload the current SCO.  All processing


	//       relative to the current page must be performed prior


	//		 to calling LMSFinish.   


   


   result = scorm.Terminate();





}





/*******************************************************************************


** this function will convert seconds into hours, minutes, and seconds in


** CMITimespan type format - HHHH:MM:SS.SS (Hours has a max of 4 digits &


** Min of 2 digits


*******************************************************************************/


function convertTotalSeconds(ts)


{


   var sec = (ts % 60);





   ts -= sec;


   var tmp = (ts % 3600);  //# of seconds in the total # of minutes


   ts -= tmp;              //# of seconds in the total # of hours





   // convert seconds to conform to CMITimespan type (e.g. SS.00)


   sec = Math.round(sec*100)/100;


   


   var strSec = new String(sec);


   var strWholeSec = strSec;


   var strFractionSec = "";





   if (strSec.indexOf(".") != -1)


   {


      strWholeSec =  strSec.substring(0, strSec.indexOf("."));


      strFractionSec = strSec.substring(strSec.indexOf(".")+1, strSec.length);


   }


   


   if (strWholeSec.length < 2)


   {


      strWholeSec = "0" + strWholeSec;


   }


   strSec = strWholeSec;


   


   if (strFractionSec.length)


   {


      strSec = strSec+ "." + strFractionSec;


   }








   if ((ts % 3600) != 0 )


      var hour = 0;


   else var hour = (ts / 3600);


   if ( (tmp % 60) != 0 )


      var min = 0;


   else var min = (tmp / 60);





   if ((new String(hour)).length < 2)


      hour = "0"+hour;


   if ((new String(min)).length < 2)


      min = "0"+min;





   var rtnVal = hour+":"+min+":"+strSec;





   return rtnVal;


}





function goBack() {


scorm.set('nav.event','previous');


var coreSCOLocation = doLMSGetValue("cmi.core.lesson_location");


window.location = coreSCOLocation;


}








function goForward() {


scorm.set('nav.event','continue');


var coreSCOLocation = doLMSGetValue("cmi.core.lesson_location");


window.location = coreSCOLocation;


}


