/*! Built with IMPACT - impactjs.com */

(function(window){"use strict";Number.prototype.map=function(istart,istop,ostart,ostop){return ostart+(ostop-ostart)*((this-istart)/(istop-istart));};Number.prototype.limit=function(min,max){return Math.min(max,Math.max(min,this));};Number.prototype.round=function(precision){precision=Math.pow(10,precision||0);return Math.round(this*precision)/precision;};Number.prototype.floor=function(){return Math.floor(this);};Number.prototype.ceil=function(){return Math.ceil(this);};Number.prototype.toInt=function(){return(this|0);};Number.prototype.toRad=function(){return(this/180)*Math.PI;};Number.prototype.toDeg=function(){return(this*180)/Math.PI;};Array.prototype.erase=function(item){for(var i=this.length;i--;){if(this[i]===item){this.splice(i,1);}}
return this;};Array.prototype.random=function(){return this[Math.floor(Math.random()*this.length)];};Function.prototype.bind=Function.prototype.bind||function(bind){var self=this;return function(){var args=Array.prototype.slice.call(arguments);return self.apply(bind||null,args);};};window.ig={game:null,debug:null,version:'1.20',global:window,modules:{},resources:[],ready:false,baked:false,nocache:'',ua:{},prefix:(window.ImpactPrefix||''),lib:'lib/',_current:null,_loadQueue:[],_waitForOnload:0,$:function(selector){return selector.charAt(0)=='#'?document.getElementById(selector.substr(1)):document.getElementsByTagName(selector);},$new:function(name){return document.createElement(name);},copy:function(object){if(!object||typeof(object)!='object'||object instanceof HTMLElement||object instanceof ig.Class){return object;}
else if(object instanceof Array){var c=[];for(var i=0,l=object.length;i<l;i++){c[i]=ig.copy(object[i]);}
return c;}
else{var c={};for(var i in object){c[i]=ig.copy(object[i]);}
return c;}},merge:function(original,extended){for(var key in extended){var ext=extended[key];if(typeof(ext)!='object'||ext instanceof HTMLElement||ext instanceof ig.Class){original[key]=ext;}
else{if(!original[key]||typeof(original[key])!='object'){original[key]=(ext instanceof Array)?[]:{};}
ig.merge(original[key],ext);}}
return original;},ksort:function(obj){if(!obj||typeof(obj)!='object'){return[];}
var keys=[],values=[];for(var i in obj){keys.push(i);}
keys.sort();for(var i=0;i<keys.length;i++){values.push(obj[keys[i]]);}
return values;},module:function(name){if(ig._current){throw("Module '"+ig._current.name+"' defines nothing");}
if(ig.modules[name]&&ig.modules[name].body){throw("Module '"+name+"' is already defined");}
ig._current={name:name,requires:[],loaded:false,body:null};ig.modules[name]=ig._current;ig._loadQueue.push(ig._current);return ig;},requires:function(){ig._current.requires=Array.prototype.slice.call(arguments);return ig;},defines:function(body){ig._current.body=body;ig._current=null;ig._initDOMReady();},addResource:function(resource){ig.resources.push(resource);},setNocache:function(set){ig.nocache=set?'?'+Date.now():'';},log:function(){},assert:function(condition,msg){},show:function(name,number){},mark:function(msg,color){},_loadScript:function(name,requiredFrom){ig.modules[name]={name:name,requires:[],loaded:false,body:null};ig._waitForOnload++;var path=ig.prefix+ig.lib+name.replace(/\./g,'/')+'.js'+ig.nocache;var script=ig.$new('script');script.type='text/javascript';script.src=path;script.onload=function(){ig._waitForOnload--;ig._execModules();};script.onerror=function(){throw('Failed to load module '+name+' at '+path+' '+'required from '+requiredFrom);};ig.$('head')[0].appendChild(script);},_execModules:function(){var modulesLoaded=false;for(var i=0;i<ig._loadQueue.length;i++){var m=ig._loadQueue[i];var dependenciesLoaded=true;for(var j=0;j<m.requires.length;j++){var name=m.requires[j];if(!ig.modules[name]){dependenciesLoaded=false;ig._loadScript(name,m.name);}
else if(!ig.modules[name].loaded){dependenciesLoaded=false;}}
if(dependenciesLoaded&&m.body){ig._loadQueue.splice(i,1);m.loaded=true;m.body();modulesLoaded=true;i--;}}
if(modulesLoaded){ig._execModules();}
else if(!ig.baked&&ig._waitForOnload==0&&ig._loadQueue.length!=0){var unresolved=[];for(var i=0;i<ig._loadQueue.length;i++){var unloaded=[];var requires=ig._loadQueue[i].requires;for(var j=0;j<requires.length;j++){var m=ig.modules[requires[j]];if(!m||!m.loaded){unloaded.push(requires[j]);}}
unresolved.push(ig._loadQueue[i].name+' (requires: '+unloaded.join(', ')+')');}
throw('Unresolved (circular?) dependencies. '+"Most likely there's a name/path mismatch for one of the listed modules:\n"+
unresolved.join('\n'));}},_DOMReady:function(){if(!ig.modules['dom.ready'].loaded){if(!document.body){return setTimeout(ig._DOMReady,13);}
ig.modules['dom.ready'].loaded=true;ig._waitForOnload--;ig._execModules();}
return 0;},_boot:function(){if(document.location.href.match(/\?nocache/)){ig.setNocache(true);}
ig.ua.pixelRatio=window.devicePixelRatio||1;ig.ua.viewport={width:window.innerWidth,height:window.innerHeight};ig.ua.screen={width:window.screen.availWidth*ig.ua.pixelRatio,height:window.screen.availHeight*ig.ua.pixelRatio};ig.ua.iPhone=/iPhone/i.test(navigator.userAgent);ig.ua.iPhone4=(ig.ua.iPhone&&ig.ua.pixelRatio==2);ig.ua.iPad=/iPad/i.test(navigator.userAgent);ig.ua.android=/android/i.test(navigator.userAgent);ig.ua.iOS=ig.ua.iPhone||ig.ua.iPad;ig.ua.mobile=ig.ua.iOS||ig.ua.android;},_initDOMReady:function(){if(ig.modules['dom.ready']){ig._execModules();return;}
ig._boot();ig.modules['dom.ready']={requires:[],loaded:false,body:null};ig._waitForOnload++;if(document.readyState==='complete'){ig._DOMReady();}
else{document.addEventListener('DOMContentLoaded',ig._DOMReady,false);window.addEventListener('load',ig._DOMReady,false);}}};var vendors=['ms','moz','webkit','o'];for(var i=0;i<vendors.length&&!window.requestAnimationFrame;i++){window.requestAnimationFrame=window[vendors[i]+'RequestAnimationFrame'];}
if(window.requestAnimationFrame){var next=1,anims={};window.ig.setAnimation=function(callback,element){var current=next++;anims[current]=true;var animate=function(){if(!anims[current]){return;}
window.requestAnimationFrame(animate,element);callback();};window.requestAnimationFrame(animate,element);return current;};window.ig.clearAnimation=function(id){delete anims[id];};}
else{window.ig.setAnimation=function(callback,element){return window.setInterval(callback,1000/60);};window.ig.clearAnimation=function(id){window.clearInterval(id);};}
var initializing=false,fnTest=/xyz/.test(function(){xyz;})?/\bparent\b/:/.*/;window.ig.Class=function(){};var inject=function(prop){var proto=this.prototype;var parent={};for(var name in prop){if(typeof(prop[name])=="function"&&typeof(proto[name])=="function"&&fnTest.test(prop[name])){parent[name]=proto[name];proto[name]=(function(name,fn){return function(){var tmp=this.parent;this.parent=parent[name];var ret=fn.apply(this,arguments);this.parent=tmp;return ret;};})(name,prop[name]);}
else{proto[name]=prop[name];}}};window.ig.Class.extend=function(prop){var parent=this.prototype;initializing=true;var prototype=new this();initializing=false;for(var name in prop){if(typeof(prop[name])=="function"&&typeof(parent[name])=="function"&&fnTest.test(prop[name])){prototype[name]=(function(name,fn){return function(){var tmp=this.parent;this.parent=parent[name];var ret=fn.apply(this,arguments);this.parent=tmp;return ret;};})(name,prop[name]);}
else{prototype[name]=prop[name];}}
function Class(){if(!initializing){if(this.staticInstantiate){var obj=this.staticInstantiate.apply(this,arguments);if(obj){return obj;}}
for(var p in this){if(typeof(this[p])=='object'){this[p]=ig.copy(this[p]);}}
if(this.init){this.init.apply(this,arguments);}}
return this;}
Class.prototype=prototype;Class.constructor=Class;Class.extend=window.ig.Class.extend;Class.inject=inject;return Class;};})(window);

// lib/impact/image.js
ig.baked=true;ig.module('impact.image').defines(function(){"use strict";ig.Image=ig.Class.extend({data:null,width:0,height:0,loaded:false,failed:false,loadCallback:null,path:'',staticInstantiate:function(path){return ig.Image.cache[path]||null;},init:function(path){this.path=path;this.load();},load:function(loadCallback){if(this.loaded){if(loadCallback){loadCallback(this.path,true);}
return;}
else if(!this.loaded&&ig.ready){this.loadCallback=loadCallback||null;this.data=new Image();this.data.onload=this.onload.bind(this);this.data.onerror=this.onerror.bind(this);this.data.src=ig.prefix+this.path+ig.nocache;}
else{ig.addResource(this);}
ig.Image.cache[this.path]=this;},reload:function(){this.loaded=false;this.data=new Image();this.data.onload=this.onload.bind(this);this.data.src=this.path+'?'+Date.now();},onload:function(event){this.width=this.data.width;this.height=this.data.height;this.loaded=true;if(ig.system.scale!=1){this.resize(ig.system.scale);}
if(this.loadCallback){this.loadCallback(this.path,true);}},onerror:function(event){this.failed=true;if(this.loadCallback){this.loadCallback(this.path,false);}},resize:function(scale){var widthScaled=this.width*scale;var heightScaled=this.height*scale;var orig=ig.$new('canvas');orig.width=this.width;orig.height=this.height;var origCtx=orig.getContext('2d');origCtx.drawImage(this.data,0,0,this.width,this.height,0,0,this.width,this.height);var origPixels=origCtx.getImageData(0,0,this.width,this.height);var scaled=ig.$new('canvas');scaled.width=widthScaled;scaled.height=heightScaled;var scaledCtx=scaled.getContext('2d');var scaledPixels=scaledCtx.getImageData(0,0,widthScaled,heightScaled);for(var y=0;y<heightScaled;y++){for(var x=0;x<widthScaled;x++){var index=(Math.floor(y/scale)*this.width+Math.floor(x/scale))*4;var indexScaled=(y*widthScaled+x)*4;scaledPixels.data[indexScaled]=origPixels.data[index];scaledPixels.data[indexScaled+1]=origPixels.data[index+1];scaledPixels.data[indexScaled+2]=origPixels.data[index+2];scaledPixels.data[indexScaled+3]=origPixels.data[index+3];}}
scaledCtx.putImageData(scaledPixels,0,0);this.data=scaled;},draw:function(targetX,targetY,sourceX,sourceY,width,height){if(!this.loaded){return;}
var scale=ig.system.scale;sourceX=sourceX?sourceX*scale:0;sourceY=sourceY?sourceY*scale:0;width=(width?width:this.width)*scale;height=(height?height:this.height)*scale;ig.system.context.drawImage(this.data,sourceX,sourceY,width,height,ig.system.getDrawPos(targetX),ig.system.getDrawPos(targetY),width,height);ig.Image.drawCount++;},drawTile:function(targetX,targetY,tile,tileWidth,tileHeight,flipX,flipY){tileHeight=tileHeight?tileHeight:tileWidth;if(!this.loaded||tileWidth>this.width||tileHeight>this.height){return;}
var scale=ig.system.scale;var tileWidthScaled=Math.floor(tileWidth*scale);var tileHeightScaled=Math.floor(tileHeight*scale);var scaleX=flipX?-1:1;var scaleY=flipY?-1:1;if(flipX||flipY){ig.system.context.save();ig.system.context.scale(scaleX,scaleY);}
ig.system.context.drawImage(this.data,(Math.floor(tile*tileWidth)%this.width)*scale,(Math.floor(tile*tileWidth/this.width)*tileHeight)*scale,tileWidthScaled,tileHeightScaled,ig.system.getDrawPos(targetX)*scaleX-(flipX?tileWidthScaled:0),ig.system.getDrawPos(targetY)*scaleY-(flipY?tileHeightScaled:0),tileWidthScaled,tileHeightScaled);if(flipX||flipY){ig.system.context.restore();}
ig.Image.drawCount++;}});ig.Image.drawCount=0;ig.Image.cache={};ig.Image.reloadCache=function(){for(var path in ig.Image.cache){ig.Image.cache[path].reload();}};});

// lib/impact/font.js
ig.baked=true;ig.module('impact.font').requires('impact.image').defines(function(){"use strict";ig.Font=ig.Image.extend({widthMap:[],indices:[],firstChar:32,alpha:1,letterSpacing:1,lineSpacing:0,onload:function(ev){this._loadMetrics(this.data);this.parent(ev);},widthForString:function(text){if(text.indexOf('\n')!==-1){var lines=text.split('\n');var width=0;for(var i=0;i<lines.length;i++){width=Math.max(width,this._widthForLine(lines[i]));}
return width;}
else{return this._widthForLine(text);}},_widthForLine:function(text){var width=0;for(var i=0;i<text.length;i++){width+=this.widthMap[text.charCodeAt(i)-this.firstChar]+this.letterSpacing;}
return width;},heightForString:function(text){return text.split('\n').length*(this.height+this.lineSpacing);},draw:function(text,x,y,align){if(typeof(text)!='string'){text=text.toString();}
if(text.indexOf('\n')!==-1){var lines=text.split('\n');var lineHeight=this.height+this.lineSpacing;for(var i=0;i<lines.length;i++){this.draw(lines[i],x,y+i*lineHeight,align);}
return;}
if(align==ig.Font.ALIGN.RIGHT||align==ig.Font.ALIGN.CENTER){var width=this._widthForLine(text);x-=align==ig.Font.ALIGN.CENTER?width/2:width;}
if(this.alpha!==1){ig.system.context.globalAlpha=this.alpha;}
for(var i=0;i<text.length;i++){var c=text.charCodeAt(i);x+=this._drawChar(c-this.firstChar,x,y);}
if(this.alpha!==1){ig.system.context.globalAlpha=1;}
ig.Image.drawCount+=text.length;},_drawChar:function(c,targetX,targetY){if(!this.loaded||c<0||c>=this.indices.length){return 0;}
var scale=ig.system.scale;var charX=this.indices[c]*scale;var charY=0;var charWidth=this.widthMap[c]*scale;var charHeight=(this.height-2)*scale;ig.system.context.drawImage(this.data,charX,charY,charWidth,charHeight,ig.system.getDrawPos(targetX),ig.system.getDrawPos(targetY),charWidth,charHeight);return this.widthMap[c]+this.letterSpacing;},_loadMetrics:function(image){this.height=image.height-1;this.widthMap=[];this.indices=[];var canvas=ig.$new('canvas');canvas.width=image.width;canvas.height=image.height;var ctx=canvas.getContext('2d');ctx.drawImage(image,0,0);var px=ctx.getImageData(0,image.height-1,image.width,1);var currentChar=0;var currentWidth=0;for(var x=0;x<image.width;x++){var index=x*4+3;if(px.data[index]!=0){currentWidth++;}
else if(px.data[index]==0&&currentWidth){this.widthMap.push(currentWidth);this.indices.push(x-currentWidth);currentChar++;currentWidth=0;}}
this.widthMap.push(currentWidth);this.indices.push(x-currentWidth);}});ig.Font.ALIGN={LEFT:0,RIGHT:1,CENTER:2};});

// lib/impact/sound.js
ig.baked=true;ig.module('impact.sound').defines(function(){"use strict";ig.SoundManager=ig.Class.extend({clips:{},volume:1,format:null,init:function(){var probe=new Audio();for(var i=0;i<ig.Sound.use.length;i++){var format=ig.Sound.use[i];if(probe.canPlayType(format.mime)){this.format=format;break;}}
if(!this.format){ig.Sound.enabled=false;}},load:function(path,multiChannel,loadCallback){var realPath=ig.prefix+path.replace(/[^\.]+$/,this.format.ext)+ig.nocache;if(this.clips[path]){if(multiChannel&&this.clips[path].length<ig.Sound.channels){for(var i=this.clips[path].length;i<ig.Sound.channels;i++){var a=new Audio(realPath);a.load();this.clips[path].push(a);}}
return this.clips[path][0];}
var clip=new Audio(realPath);if(loadCallback){clip.addEventListener('canplaythrough',function cb(ev){clip.removeEventListener('canplaythrough',cb,false);loadCallback(path,true,ev);},false);clip.addEventListener('error',function(ev){loadCallback(path,false,ev);},false);}
clip.preload='auto';clip.load();this.clips[path]=[clip];if(multiChannel){for(var i=1;i<ig.Sound.channels;i++){var a=new Audio(realPath);a.load();this.clips[path].push(a);}}
return clip;},get:function(path){var channels=this.clips[path];for(var i=0,clip;clip=channels[i++];){if(clip.paused||clip.ended){if(clip.ended){clip.currentTime=0;}
return clip;}}
channels[0].pause();channels[0].currentTime=0;return channels[0];}});ig.Music=ig.Class.extend({tracks:[],namedTracks:{},currentTrack:null,currentIndex:0,random:false,_volume:1,_loop:false,_fadeInterval:0,_fadeTimer:null,_endedCallbackBound:null,init:function(){this._endedCallbackBound=this._endedCallback.bind(this);if(Object.defineProperty){Object.defineProperty(this,"volume",{get:this.getVolume.bind(this),set:this.setVolume.bind(this)});Object.defineProperty(this,"loop",{get:this.getLooping.bind(this),set:this.setLooping.bind(this)});}
else if(this.__defineGetter__){this.__defineGetter__('volume',this.getVolume.bind(this));this.__defineSetter__('volume',this.setVolume.bind(this));this.__defineGetter__('loop',this.getLooping.bind(this));this.__defineSetter__('loop',this.setLooping.bind(this));}},add:function(music,name){if(!ig.Sound.enabled){return;}
var path=music instanceof ig.Sound?music.path:music;var track=ig.soundManager.load(path,false);track.loop=this._loop;track.volume=this._volume;track.addEventListener('ended',this._endedCallbackBound,false);this.tracks.push(track);if(name){this.namedTracks[name]=track;}
if(!this.currentTrack){this.currentTrack=track;}},next:function(){if(!this.tracks.length){return;}
this.stop();this.currentIndex=this.random?Math.floor(Math.random()*this.tracks.length):(this.currentIndex+1)%this.tracks.length;this.currentTrack=this.tracks[this.currentIndex];this.play();},pause:function(){if(!this.currentTrack){return;}
this.currentTrack.pause();},stop:function(){if(!this.currentTrack){return;}
this.currentTrack.pause();this.currentTrack.currentTime=0;},play:function(name){if(name&&this.namedTracks[name]){var newTrack=this.namedTracks[name];if(newTrack!=this.currentTrack){this.stop();this.currentTrack=newTrack;}}
else if(!this.currentTrack){return;}
this.currentTrack.play();},getLooping:function(){return this._loop;},setLooping:function(l){this._loop=l;for(var i in this.tracks){this.tracks[i].loop=l;}},getVolume:function(){return this._volume;},setVolume:function(v){this._volume=v.limit(0,1);for(var i in this.tracks){this.tracks[i].volume=this._volume;}},fadeOut:function(time){if(!this.currentTrack){return;}
clearInterval(this._fadeInterval);this.fadeTimer=new ig.Timer(time);this._fadeInterval=setInterval(this._fadeStep.bind(this),50);},_fadeStep:function(){var v=this.fadeTimer.delta().map(-this.fadeTimer.target,0,1,0).limit(0,1)*this._volume;if(v<=0.01){this.stop();this.currentTrack.volume=this._volume;clearInterval(this._fadeInterval);}
else{this.currentTrack.volume=v;}},_endedCallback:function(){if(this._loop){this.play();}
else{this.next();}}});ig.Sound=ig.Class.extend({path:'',volume:1,currentClip:null,multiChannel:true,init:function(path,multiChannel){this.path=path;this.multiChannel=(multiChannel!==false);this.load();},load:function(loadCallback){if(!ig.Sound.enabled){if(loadCallback){loadCallback(this.path,true);}
return;}
if(ig.ready){ig.soundManager.load(this.path,this.multiChannel,loadCallback);}
else{ig.addResource(this);}},play:function(){if(!ig.Sound.enabled){return;}
this.currentClip=ig.soundManager.get(this.path);this.currentClip.volume=ig.soundManager.volume*this.volume;this.currentClip.play();},stop:function(){if(this.currentClip){this.currentClip.pause();this.currentClip.currentTime=0;}}});ig.Sound.FORMAT={MP3:{ext:'mp3',mime:'audio/mpeg'},M4A:{ext:'m4a',mime:'audio/mp4; codecs=mp4a'},OGG:{ext:'ogg',mime:'audio/ogg; codecs=vorbis'},WEBM:{ext:'webm',mime:'audio/webm; codecs=vorbis'},CAF:{ext:'caf',mime:'audio/x-caf'}};ig.Sound.use=[ig.Sound.FORMAT.OGG,ig.Sound.FORMAT.MP3];ig.Sound.channels=4;ig.Sound.enabled=true;});

// lib/impact/loader.js
ig.baked=true;ig.module('impact.loader').requires('impact.image','impact.font','impact.sound').defines(function(){"use strict";ig.Loader=ig.Class.extend({resources:[],gameClass:null,status:0,done:false,_unloaded:[],_drawStatus:0,_intervalId:0,_loadCallbackBound:null,init:function(gameClass,resources){this.gameClass=gameClass;this.resources=resources;this._loadCallbackBound=this._loadCallback.bind(this);for(var i=0;i<this.resources.length;i++){this._unloaded.push(this.resources[i].path);}},load:function(){ig.system.clear('#000');if(!this.resources.length){this.end();return;}
for(var i=0;i<this.resources.length;i++){this.loadResource(this.resources[i]);}
this._intervalId=setInterval(this.draw.bind(this),16);},loadResource:function(res){res.load(this._loadCallbackBound);},end:function(){if(this.done){return;}
this.done=true;clearInterval(this._intervalId);ig.system.setGame(this.gameClass);},imageshown:false,draw:function(){ig.system.context.clearRect(0,ig.system.height*0.5-h/2,ig.system.realWidth,ig.system.height*0.01);this._drawStatus+=(this.status-this._drawStatus)/5;var s=ig.system.scale;var w=ig.system.width*0.6;var h=ig.system.height*0.01;var x=ig.system.width*0.5-w/2+(181/2);var y=ig.system.height*0.5-h/2;ig.system.context.fillStyle='#3583d1';ig.system.context.fillRect(x*s,y*s,w*s,h*s);ig.system.context.fillStyle='#000';ig.system.context.fillRect(x*s+s,y*s+s,w*s-s-s,h*s-s-s);ig.system.context.fillStyle='#3583d1';ig.system.context.fillRect(x*s,y*s,w*s*this._drawStatus,h*s);},_loadCallback:function(path,status){if(status){this._unloaded.erase(path);}
else{throw('Failed to load resource: '+path);}
this.status=1-(this._unloaded.length/this.resources.length);if(this._unloaded.length==0){setTimeout(this.end.bind(this),250);}}});});

// lib/impact/timer.js
ig.baked=true;ig.module('impact.timer').defines(function(){"use strict";ig.Timer=ig.Class.extend({target:0,base:0,last:0,pausedAt:0,init:function(seconds){this.base=ig.Timer.time;this.last=ig.Timer.time;this.target=seconds||0;},set:function(seconds){this.target=seconds||0;this.base=ig.Timer.time;this.pausedAt=0;},reset:function(){this.base=ig.Timer.time;this.pausedAt=0;},tick:function(){var delta=ig.Timer.time-this.last;this.last=ig.Timer.time;return(this.pausedAt?0:delta);},delta:function(){return(this.pausedAt||ig.Timer.time)-this.base-this.target;},pause:function(){if(!this.pausedAt){this.pausedAt=ig.Timer.time;}},unpause:function(){if(this.pausedAt){this.base+=ig.Timer.time-this.pausedAt;this.pausedAt=0;}}});ig.Timer._last=0;ig.Timer.time=0;ig.Timer.timeScale=1;ig.Timer.maxStep=0.05;ig.Timer.step=function(){var current=Date.now();var delta=(current-ig.Timer._last)/1000;ig.Timer.time+=Math.min(delta,ig.Timer.maxStep)*ig.Timer.timeScale;ig.Timer._last=current;};});

// lib/impact/system.js
ig.baked=true;ig.module('impact.system').requires('impact.timer','impact.image').defines(function(){"use strict";ig.System=ig.Class.extend({fps:30,width:320,height:240,realWidth:320,realHeight:240,scale:1,tick:0,animationId:0,newGameClass:null,running:false,delegate:null,clock:null,canvas:null,context:null,init:function(canvasId,fps,width,height,scale){this.fps=fps;this.clock=new ig.Timer();this.canvas=ig.$(canvasId);this.resize(width,height,scale);this.context=this.canvas.getContext('2d');this.getDrawPos=ig.System.drawMode;},resize:function(width,height,scale){this.width=width;this.height=height;this.scale=scale||this.scale;this.realWidth=this.width*this.scale;this.realHeight=this.height*this.scale;this.canvas.width=this.realWidth;this.canvas.height=this.realHeight;},setGame:function(gameClass){if(this.running){this.newGameClass=gameClass;}
else{this.setGameNow(gameClass);}},setGameNow:function(gameClass){ig.game=new(gameClass)();ig.system.setDelegate(ig.game);},setDelegate:function(object){if(typeof(object.run)=='function'){this.delegate=object;this.startRunLoop();}else{throw('System.setDelegate: No run() function in object');}},stopRunLoop:function(){ig.clearAnimation(this.animationId);this.running=false;},startRunLoop:function(){this.stopRunLoop();this.animationId=ig.setAnimation(this.run.bind(this),this.canvas);this.running=true;},clear:function(color){this.context.fillStyle=color;this.context.fillRect(0,0,this.realWidth,this.realHeight);},run:function(){ig.Timer.step();this.tick=this.clock.tick();this.delegate.run();ig.input.clearPressed();if(this.newGameClass){this.setGameNow(this.newGameClass);this.newGameClass=null;}},getDrawPos:null,});ig.System.DRAW={AUTHENTIC:function(p){return Math.round(p)*this.scale;},SMOOTH:function(p){return Math.round(p*this.scale);},SUBPIXEL:function(p){return p*this.scale;}};ig.System.drawMode=ig.System.DRAW.SMOOTH;});

// lib/impact/input.js
ig.baked=true;ig.module('impact.input').defines(function(){"use strict";ig.KEY={'MOUSE1':-1,'MOUSE2':-3,'MWHEEL_UP':-4,'MWHEEL_DOWN':-5,'BACKSPACE':8,'TAB':9,'ENTER':13,'PAUSE':19,'CAPS':20,'ESC':27,'SPACE':32,'PAGE_UP':33,'PAGE_DOWN':34,'END':35,'HOME':36,'LEFT_ARROW':37,'UP_ARROW':38,'RIGHT_ARROW':39,'DOWN_ARROW':40,'INSERT':45,'DELETE':46,'_0':48,'_1':49,'_2':50,'_3':51,'_4':52,'_5':53,'_6':54,'_7':55,'_8':56,'_9':57,'A':65,'B':66,'C':67,'D':68,'E':69,'F':70,'G':71,'H':72,'I':73,'J':74,'K':75,'L':76,'M':77,'N':78,'O':79,'P':80,'Q':81,'R':82,'S':83,'T':84,'U':85,'V':86,'W':87,'X':88,'Y':89,'Z':90,'NUMPAD_0':96,'NUMPAD_1':97,'NUMPAD_2':98,'NUMPAD_3':99,'NUMPAD_4':100,'NUMPAD_5':101,'NUMPAD_6':102,'NUMPAD_7':103,'NUMPAD_8':104,'NUMPAD_9':105,'MULTIPLY':106,'ADD':107,'SUBSTRACT':109,'DECIMAL':110,'DIVIDE':111,'F1':112,'F2':113,'F3':114,'F4':115,'F5':116,'F6':117,'F7':118,'F8':119,'F9':120,'F10':121,'F11':122,'F12':123,'SHIFT':16,'CTRL':17,'ALT':18,'PLUS':187,'COMMA':188,'MINUS':189,'PERIOD':190};ig.Input=ig.Class.extend({bindings:{},actions:{},presses:{},locks:{},delayedKeyup:{},isUsingMouse:false,isUsingKeyboard:false,isUsingAccelerometer:false,mouse:{x:0,y:0},accel:{x:0,y:0,z:0},initMouse:function(){if(this.isUsingMouse){return;}
this.isUsingMouse=true;var mouseWheelBound=this.mousewheel.bind(this);ig.system.canvas.addEventListener('mousewheel',mouseWheelBound,false);ig.system.canvas.addEventListener('DOMMouseScroll',mouseWheelBound,false);ig.system.canvas.addEventListener('contextmenu',this.contextmenu.bind(this),false);ig.system.canvas.addEventListener('mousedown',this.keydown.bind(this),false);ig.system.canvas.addEventListener('mouseup',this.keyup.bind(this),false);ig.system.canvas.addEventListener('mousemove',this.mousemove.bind(this),false);ig.system.canvas.addEventListener('touchstart',this.keydown.bind(this),false);ig.system.canvas.addEventListener('touchend',this.keyup.bind(this),false);ig.system.canvas.addEventListener('touchmove',this.mousemove.bind(this),false);},initKeyboard:function(){if(this.isUsingKeyboard){return;}
this.isUsingKeyboard=true;window.addEventListener('keydown',this.keydown.bind(this),false);window.addEventListener('keyup',this.keyup.bind(this),false);},initAccelerometer:function(){if(this.isUsingAccelerometer){return;}
window.addEventListener('devicemotion',this.devicemotion.bind(this),false);},mousewheel:function(event){var delta=event.wheelDelta?event.wheelDelta:(event.detail*-1);var code=delta>0?ig.KEY.MWHEEL_UP:ig.KEY.MWHEEL_DOWN;var action=this.bindings[code];if(action){this.actions[action]=true;this.presses[action]=true;this.delayedKeyup[action]=true;event.stopPropagation();event.preventDefault();}},mousemove:function(event){var el=ig.system.canvas;var pos={left:0,top:0};while(el!=null){pos.left+=el.offsetLeft;pos.top+=el.offsetTop;el=el.offsetParent;}
var tx=event.pageX;var ty=event.pageY;if(event.touches){tx=event.touches[0].clientX;ty=event.touches[0].clientY;}
this.mouse.x=(tx-pos.left)/ig.system.scale;this.mouse.y=(ty-pos.top)/ig.system.scale;},contextmenu:function(event){if(this.bindings[ig.KEY.MOUSE2]){event.stopPropagation();event.preventDefault();}},keydown:function(event){if(event.target.type=='text'){return;}
var code=event.type=='keydown'?event.keyCode:(event.button==2?ig.KEY.MOUSE2:ig.KEY.MOUSE1);if(event.type=='touchstart'||event.type=='mousedown'){this.mousemove(event);}
var action=this.bindings[code];if(action){this.actions[action]=true;if(!this.locks[action]){this.presses[action]=true;this.locks[action]=true;}
event.stopPropagation();event.preventDefault();}},keyup:function(event){if(event.target.type=='text'){return;}
var code=event.type=='keyup'?event.keyCode:(event.button==2?ig.KEY.MOUSE2:ig.KEY.MOUSE1);var action=this.bindings[code];if(action){this.delayedKeyup[action]=true;event.stopPropagation();event.preventDefault();}},devicemotion:function(event){this.accel=event.accelerationIncludingGravity;},bind:function(key,action){if(key<0){this.initMouse();}
else if(key>0){this.initKeyboard();}
this.bindings[key]=action;},bindTouch:function(selector,action){var element=ig.$(selector);var that=this;element.addEventListener('touchstart',function(ev){that.touchStart(ev,action);},false);element.addEventListener('touchend',function(ev){that.touchEnd(ev,action);},false);},unbind:function(key){var action=this.bindings[key];this.delayedKeyup[action]=true;this.bindings[key]=null;},unbindAll:function(){this.bindings={};this.actions={};this.presses={};this.locks={};this.delayedKeyup={};},state:function(action){return this.actions[action];},pressed:function(action){return this.presses[action];},released:function(action){return this.delayedKeyup[action];},clearPressed:function(){for(var action in this.delayedKeyup){this.actions[action]=false;this.locks[action]=false;}
this.delayedKeyup={};this.presses={};},touchStart:function(event,action){this.actions[action]=true;this.presses[action]=true;event.stopPropagation();event.preventDefault();return false;},touchEnd:function(event,action){this.delayedKeyup[action]=true;event.stopPropagation();event.preventDefault();return false;}});});

// lib/impact/impact.js
ig.baked=true;ig.module('impact.impact').requires('dom.ready','impact.loader','impact.system','impact.input','impact.sound').defines(function(){"use strict";ig.main=function(canvasId,gameClass,fps,width,height,scale,loaderClass){ig.system=new ig.System(canvasId,fps,width,height,scale||1);ig.input=new ig.Input();ig.soundManager=new ig.SoundManager();ig.music=new ig.Music();ig.ready=true;var loader=new(loaderClass||ig.Loader)(gameClass,ig.resources);loader.load();};});

// lib/impact/animation.js
ig.baked=true;ig.module('impact.animation').requires('impact.timer','impact.image').defines(function(){"use strict";ig.AnimationSheet=ig.Class.extend({width:8,height:8,image:null,init:function(path,width,height){this.width=width;this.height=height;this.image=new ig.Image(path);}});ig.Animation=ig.Class.extend({sheet:null,timer:null,sequence:[],flip:{x:false,y:false},pivot:{x:0,y:0},frame:0,tile:0,loopCount:0,alpha:1,angle:0,init:function(sheet,frameTime,sequence,stop){this.sheet=sheet;this.pivot={x:sheet.width/2,y:sheet.height/2};this.timer=new ig.Timer();this.frameTime=frameTime;this.sequence=sequence;this.stop=!!stop;this.tile=this.sequence[0];},rewind:function(){this.timer.reset();this.loopCount=0;this.tile=this.sequence[0];return this;},gotoFrame:function(f){this.timer.set(this.frameTime*-f);this.update();},gotoRandomFrame:function(){this.gotoFrame(Math.floor(Math.random()*this.sequence.length))},update:function(){var frameTotal=Math.floor(this.timer.delta()/this.frameTime);this.loopCount=Math.floor(frameTotal/this.sequence.length);if(this.stop&&this.loopCount>0){this.frame=this.sequence.length-1;}
else{this.frame=frameTotal%this.sequence.length;}
this.tile=this.sequence[this.frame];},draw:function(targetX,targetY){var bbsize=Math.max(this.sheet.width,this.sheet.height);if(targetX>ig.system.width||targetY>ig.system.height||targetX+bbsize<0||targetY+bbsize<0){return;}
if(this.alpha!=1){ig.system.context.globalAlpha=this.alpha;}
if(this.angle==0){this.sheet.image.drawTile(targetX,targetY,this.tile,this.sheet.width,this.sheet.height,this.flip.x,this.flip.y);}
else{ig.system.context.save();ig.system.context.translate(ig.system.getDrawPos(targetX+this.pivot.x),ig.system.getDrawPos(targetY+this.pivot.y));ig.system.context.rotate(this.angle);this.sheet.image.drawTile(-this.pivot.x,-this.pivot.y,this.tile,this.sheet.width,this.sheet.height,this.flip.x,this.flip.y);ig.system.context.restore();}
if(this.alpha!=1){ig.system.context.globalAlpha=1;}}});});

// lib/impact/entity.js
ig.baked=true;ig.module('impact.entity').requires('impact.animation','impact.impact').defines(function(){"use strict";ig.Entity=ig.Class.extend({id:0,settings:{},size:{x:16,y:16},offset:{x:0,y:0},pos:{x:0,y:0},last:{x:0,y:0},vel:{x:0,y:0},accel:{x:0,y:0},friction:{x:0,y:0},maxVel:{x:100,y:100},zIndex:0,gravityFactor:1,standing:false,bounciness:0,minBounceVelocity:40,anims:{},animSheet:null,currentAnim:null,health:10,type:0,checkAgainst:0,collides:0,_killed:false,slopeStanding:{min:(44).toRad(),max:(136).toRad()},init:function(x,y,settings){this.id=++ig.Entity._lastId;this.pos.x=x;this.pos.y=y;ig.merge(this,settings);},addAnim:function(name,frameTime,sequence,stop){if(!this.animSheet){throw('No animSheet to add the animation '+name+' to.');}
var a=new ig.Animation(this.animSheet,frameTime,sequence,stop);this.anims[name]=a;if(!this.currentAnim){this.currentAnim=a;}
return a;},update:function(){this.last.x=this.pos.x;this.last.y=this.pos.y;this.vel.y+=ig.game.gravity*ig.system.tick*this.gravityFactor;this.vel.x=this.getNewVelocity(this.vel.x,this.accel.x,this.friction.x,this.maxVel.x);this.vel.y=this.getNewVelocity(this.vel.y,this.accel.y,this.friction.y,this.maxVel.y);var mx=this.vel.x*ig.system.tick;var my=this.vel.y*ig.system.tick;var res=ig.game.collisionMap.trace(this.pos.x,this.pos.y,mx,my,this.size.x,this.size.y);this.handleMovementTrace(res);if(this.currentAnim){this.currentAnim.update();}},getNewVelocity:function(vel,accel,friction,max){if(accel){return(vel+accel*ig.system.tick).limit(-max,max);}
else if(friction){var delta=friction*ig.system.tick;if(vel-delta>0){return vel-delta;}
else if(vel+delta<0){return vel+delta;}
else{return 0;}}
return vel.limit(-max,max);},handleMovementTrace:function(res){this.standing=false;if(res.collision.y){if(this.bounciness>0&&Math.abs(this.vel.y)>this.minBounceVelocity){this.vel.y*=-this.bounciness;}
else{if(this.vel.y>0){this.standing=true;}
this.vel.y=0;}}
if(res.collision.x){if(this.bounciness>0&&Math.abs(this.vel.x)>this.minBounceVelocity){this.vel.x*=-this.bounciness;}
else{this.vel.x=0;}}
if(res.collision.slope){var s=res.collision.slope;if(this.bounciness>0){var proj=this.vel.x*s.nx+this.vel.y*s.ny;this.vel.x=(this.vel.x-s.nx*proj*2)*this.bounciness;this.vel.y=(this.vel.y-s.ny*proj*2)*this.bounciness;}
else{var lengthSquared=s.x*s.x+s.y*s.y;var dot=(this.vel.x*s.x+this.vel.y*s.y)/lengthSquared;this.vel.x=s.x*dot;this.vel.y=s.y*dot;var angle=Math.atan2(s.x,s.y);if(angle>this.slopeStanding.min&&angle<this.slopeStanding.max){this.standing=true;}}}
this.pos=res.pos;},draw:function(){if(this.currentAnim){this.currentAnim.draw(this.pos.x-this.offset.x-ig.game._rscreen.x,this.pos.y-this.offset.y-ig.game._rscreen.y);}},kill:function(){ig.game.removeEntity(this);},receiveDamage:function(amount,from){this.health-=amount;if(this.health<=0){this.kill();}},touches:function(other){return!(this.pos.x>=other.pos.x+other.size.x||this.pos.x+this.size.x<=other.pos.x||this.pos.y>=other.pos.y+other.size.y||this.pos.y+this.size.y<=other.pos.y);},distanceTo:function(other){var xd=(this.pos.x+this.size.x/2)-(other.pos.x+other.size.x/2);var yd=(this.pos.y+this.size.y/2)-(other.pos.y+other.size.y/2);return Math.sqrt(xd*xd+yd*yd);},angleTo:function(other){return Math.atan2((other.pos.y+other.size.y/2)-(this.pos.y+this.size.y/2),(other.pos.x+other.size.x/2)-(this.pos.x+this.size.x/2));},check:function(other){},collideWith:function(other,axis){},ready:function(){}});ig.Entity._lastId=0;ig.Entity.COLLIDES={NEVER:0,LITE:1,PASSIVE:2,ACTIVE:4,FIXED:8};ig.Entity.TYPE={NONE:0,A:1,B:2,BOTH:3};ig.Entity.checkPair=function(a,b){if(a.checkAgainst&b.type){a.check(b);}
if(b.checkAgainst&a.type){b.check(a);}
if(a.collides&&b.collides&&a.collides+b.collides>ig.Entity.COLLIDES.ACTIVE){ig.Entity.solveCollision(a,b);}};ig.Entity.solveCollision=function(a,b){var weak=null;if(a.collides==ig.Entity.COLLIDES.LITE||b.collides==ig.Entity.COLLIDES.FIXED){weak=a;}
else if(b.collides==ig.Entity.COLLIDES.LITE||a.collides==ig.Entity.COLLIDES.FIXED){weak=b;}
if(a.last.x+a.size.x>b.last.x&&a.last.x<b.last.x+b.size.x){if(a.last.y<b.last.y){ig.Entity.seperateOnYAxis(a,b,weak);}
else{ig.Entity.seperateOnYAxis(b,a,weak);}
a.collideWith(b,'y');b.collideWith(a,'y');}
else if(a.last.y+a.size.y>b.last.y&&a.last.y<b.last.y+b.size.y){if(a.last.x<b.last.x){ig.Entity.seperateOnXAxis(a,b,weak);}
else{ig.Entity.seperateOnXAxis(b,a,weak);}
a.collideWith(b,'x');b.collideWith(a,'x');}};ig.Entity.seperateOnXAxis=function(left,right,weak){var nudge=(left.pos.x+left.size.x-right.pos.x);if(weak){var strong=left===weak?right:left;weak.vel.x=-weak.vel.x*weak.bounciness+strong.vel.x;var resWeak=ig.game.collisionMap.trace(weak.pos.x,weak.pos.y,weak==left?-nudge:nudge,0,weak.size.x,weak.size.y);weak.pos.x=resWeak.pos.x;}
else{var v2=(left.vel.x-right.vel.x)/2;left.vel.x=-v2;right.vel.x=v2;var resLeft=ig.game.collisionMap.trace(left.pos.x,left.pos.y,-nudge/2,0,left.size.x,left.size.y);left.pos.x=Math.floor(resLeft.pos.x);var resRight=ig.game.collisionMap.trace(right.pos.x,right.pos.y,nudge/2,0,right.size.x,right.size.y);right.pos.x=Math.ceil(resRight.pos.x);}};ig.Entity.seperateOnYAxis=function(top,bottom,weak){var nudge=(top.pos.y+top.size.y-bottom.pos.y);if(weak){var strong=top===weak?bottom:top;weak.vel.y=-weak.vel.y*weak.bounciness+strong.vel.y;var nudgeX=0;if(weak==top&&Math.abs(weak.vel.y-strong.vel.y)<weak.minBounceVelocity){weak.standing=true;nudgeX=strong.vel.x*ig.system.tick;}
var resWeak=ig.game.collisionMap.trace(weak.pos.x,weak.pos.y,nudgeX,weak==top?-nudge:nudge,weak.size.x,weak.size.y);weak.pos.y=resWeak.pos.y;weak.pos.x=resWeak.pos.x;}
else if(ig.game.gravity&&(bottom.standing||top.vel.y>0)){var resTop=ig.game.collisionMap.trace(top.pos.x,top.pos.y,0,-(top.pos.y+top.size.y-bottom.pos.y),top.size.x,top.size.y);top.pos.y=resTop.pos.y;if(top.bounciness>0&&top.vel.y>top.minBounceVelocity){top.vel.y*=-top.bounciness;}
else{top.standing=true;top.vel.y=0;}}
else{var v2=(top.vel.y-bottom.vel.y)/2;top.vel.y=-v2;bottom.vel.y=v2;var nudgeX=bottom.vel.x*ig.system.tick;var resTop=ig.game.collisionMap.trace(top.pos.x,top.pos.y,nudgeX,-nudge/2,top.size.x,top.size.y);top.pos.y=resTop.pos.y;var resBottom=ig.game.collisionMap.trace(bottom.pos.x,bottom.pos.y,0,nudge/2,bottom.size.x,bottom.size.y);bottom.pos.y=resBottom.pos.y;}};});

// lib/impact/map.js
ig.baked=true;ig.module('impact.map').defines(function(){"use strict";ig.Map=ig.Class.extend({tilesize:8,width:1,height:1,data:[[]],name:null,init:function(tilesize,data){this.tilesize=tilesize;this.data=data;this.height=data.length;this.width=data[0].length;},getTile:function(x,y){var tx=Math.floor(x/this.tilesize);var ty=Math.floor(y/this.tilesize);if((tx>=0&&tx<this.width)&&(ty>=0&&ty<this.height)){return this.data[ty][tx];}
else{return 0;}},setTile:function(x,y,tile){var tx=Math.floor(x/this.tilesize);var ty=Math.floor(y/this.tilesize);if((tx>=0&&tx<this.width)&&(ty>=0&&ty<this.height)){this.data[ty][tx]=tile;}}});});

// lib/impact/collision-map.js
ig.baked=true;ig.module('impact.collision-map').requires('impact.map').defines(function(){"use strict";ig.CollisionMap=ig.Map.extend({lastSlope:1,tiledef:null,init:function(tilesize,data,tiledef){this.parent(tilesize,data);this.tiledef=tiledef||ig.CollisionMap.defaultTileDef;for(var t in this.tiledef){if(t|0>this.lastSlope){this.lastSlope=t|0;}}},trace:function(x,y,vx,vy,objectWidth,objectHeight){var res={collision:{x:false,y:false,slope:false},pos:{x:x,y:y},tile:{x:0,y:0}};var steps=Math.ceil(Math.max(Math.abs(vx),Math.abs(vy))/this.tilesize);if(steps>1){var sx=vx/steps;var sy=vy/steps;for(var i=0;i<steps&&(sx||sy);i++){this._traceStep(res,x,y,sx,sy,objectWidth,objectHeight,vx,vy,i);x=res.pos.x;y=res.pos.y;if(res.collision.x){sx=0;vx=0;}
if(res.collision.y){sy=0;vy=0;}
if(res.collision.slope){break;}}}
else{this._traceStep(res,x,y,vx,vy,objectWidth,objectHeight,vx,vy,0);}
return res;},_traceStep:function(res,x,y,vx,vy,width,height,rvx,rvy,step){res.pos.x+=vx;res.pos.y+=vy;var t=0;if(vx){var pxOffsetX=(vx>0?width:0);var tileOffsetX=(vx<0?this.tilesize:0);var firstTileY=Math.max(Math.floor(y/this.tilesize),0);var lastTileY=Math.min(Math.ceil((y+height)/this.tilesize),this.height);var tileX=Math.floor((res.pos.x+pxOffsetX)/this.tilesize);var prevTileX=Math.floor((x+pxOffsetX)/this.tilesize);if(step>0||tileX==prevTileX||prevTileX<0||prevTileX>=this.width){prevTileX=-1;}
if(tileX>=0&&tileX<this.width){for(var tileY=firstTileY;tileY<lastTileY;tileY++){if(prevTileX!=-1){t=this.data[tileY][prevTileX];if(t>1&&t<=this.lastSlope&&this._checkTileDef(res,t,x,y,rvx,rvy,width,height,prevTileX,tileY)){break;}}
t=this.data[tileY][tileX];if(t==1||t>this.lastSlope||(t>1&&this._checkTileDef(res,t,x,y,rvx,rvy,width,height,tileX,tileY))){if(t>1&&t<=this.lastSlope&&res.collision.slope){break;}
res.collision.x=true;res.tile.x=t;x=res.pos.x=tileX*this.tilesize-pxOffsetX+tileOffsetX;rvx=0;break;}}}}
if(vy){var pxOffsetY=(vy>0?height:0);var tileOffsetY=(vy<0?this.tilesize:0);var firstTileX=Math.max(Math.floor(res.pos.x/this.tilesize),0);var lastTileX=Math.min(Math.ceil((res.pos.x+width)/this.tilesize),this.width);var tileY=Math.floor((res.pos.y+pxOffsetY)/this.tilesize);var prevTileY=Math.floor((y+pxOffsetY)/this.tilesize);if(step>0||tileY==prevTileY||prevTileY<0||prevTileY>=this.height){prevTileY=-1;}
if(tileY>=0&&tileY<this.height){for(var tileX=firstTileX;tileX<lastTileX;tileX++){if(prevTileY!=-1){t=this.data[prevTileY][tileX];if(t>1&&t<=this.lastSlope&&this._checkTileDef(res,t,x,y,rvx,rvy,width,height,tileX,prevTileY)){break;}}
t=this.data[tileY][tileX];if(t==1||t>this.lastSlope||(t>1&&this._checkTileDef(res,t,x,y,rvx,rvy,width,height,tileX,tileY))){if(t>1&&t<=this.lastSlope&&res.collision.slope){break;}
res.collision.y=true;res.tile.y=t;res.pos.y=tileY*this.tilesize-pxOffsetY+tileOffsetY;break;}}}}},_checkTileDef:function(res,t,x,y,vx,vy,width,height,tileX,tileY){var def=this.tiledef[t];if(!def){return false;}
var lx=(tileX+def[0])*this.tilesize,ly=(tileY+def[1])*this.tilesize,lvx=(def[2]-def[0])*this.tilesize,lvy=(def[3]-def[1])*this.tilesize,solid=def[4];var tx=x+vx+(lvy<0?width:0)-lx,ty=y+vy+(lvx>0?height:0)-ly;if(lvx*ty-lvy*tx>0){if(vx*-lvy+vy*lvx<0){return solid;}
var length=Math.sqrt(lvx*lvx+lvy*lvy);var nx=lvy/length,ny=-lvx/length;var proj=tx*nx+ty*ny;var px=nx*proj,py=ny*proj;if(px*px+py*py>=vx*vx+vy*vy){return solid||(lvx*(ty-vy)-lvy*(tx-vx)<0.5);}
res.pos.x=x+vx-px;res.pos.y=y+vy-py;res.collision.slope={x:lvx,y:lvy,nx:nx,ny:ny};return true;}
return false;}});var H=1/2,N=1/3,M=2/3,SOLID=true,NON_SOLID=false;ig.CollisionMap.defaultTileDef={5:[0,1,1,M,SOLID],6:[0,M,1,N,SOLID],7:[0,N,1,0,SOLID],3:[0,1,1,H,SOLID],4:[0,H,1,0,SOLID],2:[0,1,1,0,SOLID],10:[H,1,1,0,SOLID],21:[0,1,H,0,SOLID],32:[M,1,1,0,SOLID],43:[N,1,M,0,SOLID],54:[0,1,N,0,SOLID],27:[0,0,1,N,SOLID],28:[0,N,1,M,SOLID],29:[0,M,1,1,SOLID],25:[0,0,1,H,SOLID],26:[0,H,1,1,SOLID],24:[0,0,1,1,SOLID],11:[0,0,H,1,SOLID],22:[H,0,1,1,SOLID],33:[0,0,N,1,SOLID],44:[N,0,M,1,SOLID],55:[M,0,1,1,SOLID],16:[1,N,0,0,SOLID],17:[1,M,0,N,SOLID],18:[1,1,0,M,SOLID],14:[1,H,0,0,SOLID],15:[1,1,0,H,SOLID],13:[1,1,0,0,SOLID],8:[H,1,0,0,SOLID],19:[1,1,H,0,SOLID],30:[N,1,0,0,SOLID],41:[M,1,N,0,SOLID],52:[1,1,M,0,SOLID],38:[1,M,0,1,SOLID],39:[1,N,0,M,SOLID],40:[1,0,0,N,SOLID],36:[1,H,0,1,SOLID],37:[1,0,0,H,SOLID],35:[1,0,0,1,SOLID],9:[1,0,H,1,SOLID],20:[H,0,0,1,SOLID],31:[1,0,M,1,SOLID],42:[M,0,N,1,SOLID],53:[N,0,0,1,SOLID],12:[0,0,1,0,NON_SOLID],23:[1,1,0,1,NON_SOLID],34:[1,0,1,1,NON_SOLID],45:[0,1,0,0,NON_SOLID]};ig.CollisionMap.staticNoCollision={trace:function(x,y,vx,vy){return{collision:{x:false,y:false,slope:false},pos:{x:x+vx,y:y+vy},tile:{x:0,y:0}};}};});

// lib/impact/background-map.js
ig.baked=true;ig.module('impact.background-map').requires('impact.map','impact.image').defines(function(){"use strict";ig.BackgroundMap=ig.Map.extend({tiles:null,scroll:{x:0,y:0},distance:1,repeat:false,tilesetName:'',foreground:false,enabled:true,preRender:false,preRenderedChunks:null,chunkSize:512,debugChunks:false,anims:{},init:function(tilesize,data,tileset){this.parent(tilesize,data);this.setTileset(tileset);},setTileset:function(tileset){this.tilesetName=tileset instanceof ig.Image?tileset.path:tileset;this.tiles=new ig.Image(this.tilesetName);this.preRenderedChunks=null;},setScreenPos:function(x,y){this.scroll.x=x/this.distance;this.scroll.y=y/this.distance;},preRenderMapToChunks:function(){var totalWidth=this.width*this.tilesize*ig.system.scale,totalHeight=this.height*this.tilesize*ig.system.scale;var chunkCols=Math.ceil(totalWidth/this.chunkSize),chunkRows=Math.ceil(totalHeight/this.chunkSize);this.preRenderedChunks=[];for(var y=0;y<chunkRows;y++){this.preRenderedChunks[y]=[];for(var x=0;x<chunkCols;x++){var chunkWidth=(x==chunkCols-1)?totalWidth-x*this.chunkSize:this.chunkSize;var chunkHeight=(y==chunkRows-1)?totalHeight-y*this.chunkSize:this.chunkSize;this.preRenderedChunks[y][x]=this.preRenderChunk(x,y,chunkWidth,chunkHeight);}}},preRenderChunk:function(cx,cy,w,h){var tw=w/this.tilesize/ig.system.scale+1,th=h/this.tilesize/ig.system.scale+1;var nx=(cx*this.chunkSize/ig.system.scale)%this.tilesize,ny=(cy*this.chunkSize/ig.system.scale)%this.tilesize;var tx=Math.floor(cx*this.chunkSize/this.tilesize/ig.system.scale),ty=Math.floor(cy*this.chunkSize/this.tilesize/ig.system.scale);var chunk=ig.$new('canvas');chunk.width=w;chunk.height=h;var oldContext=ig.system.context;ig.system.context=chunk.getContext("2d");for(var x=0;x<tw;x++){for(var y=0;y<th;y++){if(x+tx<this.width&&y+ty<this.height){var tile=this.data[y+ty][x+tx];if(tile){this.tiles.drawTile(x*this.tilesize-nx,y*this.tilesize-ny,tile-1,this.tilesize);}}}}
ig.system.context=oldContext;return chunk;},draw:function(){if(!this.tiles.loaded||!this.enabled){return;}
if(this.preRender){this.drawPreRendered();}
else{this.drawTiled();}},drawPreRendered:function(){if(!this.preRenderedChunks){this.preRenderMapToChunks();}
var dx=ig.system.getDrawPos(this.scroll.x),dy=ig.system.getDrawPos(this.scroll.y);if(this.repeat){dx%=this.width*this.tilesize*ig.system.scale;dy%=this.height*this.tilesize*ig.system.scale;}
var minChunkX=Math.max(Math.floor(dx/this.chunkSize),0),minChunkY=Math.max(Math.floor(dy/this.chunkSize),0),maxChunkX=Math.ceil((dx+ig.system.realWidth)/this.chunkSize),maxChunkY=Math.ceil((dy+ig.system.realHeight)/this.chunkSize),maxRealChunkX=this.preRenderedChunks[0].length,maxRealChunkY=this.preRenderedChunks.length;if(!this.repeat){maxChunkX=Math.min(maxChunkX,maxRealChunkX);maxChunkY=Math.min(maxChunkY,maxRealChunkY);}
var nudgeY=0;for(var cy=minChunkY;cy<maxChunkY;cy++){var nudgeX=0;for(var cx=minChunkX;cx<maxChunkX;cx++){var chunk=this.preRenderedChunks[cy%maxRealChunkY][cx%maxRealChunkX];var x=-dx+cx*this.chunkSize-nudgeX;var y=-dy+cy*this.chunkSize-nudgeY;ig.system.context.drawImage(chunk,x,y);ig.Image.drawCount++;if(this.debugChunks){ig.system.context.strokeStyle='#f0f';ig.system.context.strokeRect(x,y,this.chunkSize,this.chunkSize);}
if(this.repeat&&chunk.width<this.chunkSize&&x+chunk.width<ig.system.realWidth){nudgeX=this.chunkSize-chunk.width;maxChunkX++;}}
if(this.repeat&&chunk.height<this.chunkSize&&y+chunk.height<ig.system.realHeight){nudgeY=this.chunkSize-chunk.height;maxChunkY++;}}},drawTiled:function(){var tile=0,anim=null,tileOffsetX=(this.scroll.x/this.tilesize).toInt(),tileOffsetY=(this.scroll.y/this.tilesize).toInt(),pxOffsetX=this.scroll.x%this.tilesize,pxOffsetY=this.scroll.y%this.tilesize,pxMinX=-pxOffsetX-this.tilesize,pxMinY=-pxOffsetY-this.tilesize,pxMaxX=ig.system.width+this.tilesize-pxOffsetX,pxMaxY=ig.system.height+this.tilesize-pxOffsetY;for(var mapY=-1,pxY=pxMinY;pxY<pxMaxY;mapY++,pxY+=this.tilesize){var tileY=mapY+tileOffsetY;if(tileY>=this.height||tileY<0){if(!this.repeat){continue;}
tileY=tileY>0?tileY%this.height:((tileY+1)%this.height)+this.height-1;}
for(var mapX=-1,pxX=pxMinX;pxX<pxMaxX;mapX++,pxX+=this.tilesize){var tileX=mapX+tileOffsetX;if(tileX>=this.width||tileX<0){if(!this.repeat){continue;}
tileX=tileX>0?tileX%this.width:((tileX+1)%this.width)+this.width-1;}
if((tile=this.data[tileY][tileX])){if((anim=this.anims[tile-1])){anim.draw(pxX,pxY);}
else{this.tiles.drawTile(pxX,pxY,tile-1,this.tilesize);}}}}}});});

// lib/impact/game.js
ig.baked=true;ig.module('impact.game').requires('impact.impact','impact.entity','impact.collision-map','impact.background-map').defines(function(){"use strict";ig.Game=ig.Class.extend({clearColor:'#000000',gravity:0,screen:{x:0,y:0},_rscreen:{x:0,y:0},entities:[],namedEntities:{},collisionMap:ig.CollisionMap.staticNoCollision,backgroundMaps:[],backgroundAnims:{},autoSort:false,sortBy:null,cellSize:64,_deferredKill:[],_levelToLoad:null,_doSortEntities:false,staticInstantiate:function(){this.sortBy=this.sortBy||ig.Game.SORT.Z_INDEX;ig.game=this;return null;},loadLevel:function(data){this.screen={x:0,y:0};this.entities=[];this.namedEntities={};for(var i=0;i<data.entities.length;i++){var ent=data.entities[i];this.spawnEntity(ent.type,ent.x,ent.y,ent.settings);}
this.sortEntities();this.collisionMap=ig.CollisionMap.staticNoCollision;this.backgroundMaps=[];for(var i=0;i<data.layer.length;i++){var ld=data.layer[i];if(ld.name=='collision'){this.collisionMap=new ig.CollisionMap(ld.tilesize,ld.data);}
else{var newMap=new ig.BackgroundMap(ld.tilesize,ld.data,ld.tilesetName);newMap.anims=this.backgroundAnims[ld.tilesetName]||{};newMap.repeat=ld.repeat;newMap.distance=ld.distance;newMap.foreground=!!ld.foreground;newMap.preRender=!!ld.preRender;newMap.name=ld.name;this.backgroundMaps.push(newMap);}}
for(var i=0;i<this.entities.length;i++){this.entities[i].ready();}},loadLevelDeferred:function(data){this._levelToLoad=data;},getMapByName:function(name){if(name=='collision'){return this.collisionMap;}
for(var i=0;i<this.backgroundMaps.length;i++){if(this.backgroundMaps[i].name==name){return this.backgroundMaps[i];}}
return null;},getEntityByName:function(name){return this.namedEntities[name];},getEntitiesByType:function(type){var entityClass=typeof(type)==='string'?ig.global[type]:type;var a=[];for(var i=0;i<this.entities.length;i++){var ent=this.entities[i];if(ent instanceof entityClass&&!ent._killed){a.push(ent);}}
return a;},spawnEntity:function(type,x,y,settings){var entityClass=typeof(type)==='string'?ig.global[type]:type;if(!entityClass){throw("Can't spawn entity of type "+type);}
var ent=new(entityClass)(x,y,settings||{});this.entities.push(ent);if(ent.name){this.namedEntities[ent.name]=ent;}
return ent;},sortEntities:function(){this.entities.sort(this.sortBy);},sortEntitiesDeferred:function(){this._doSortEntities=true;},removeEntity:function(ent){if(ent.name){delete this.namedEntities[ent.name];}
ent._killed=true;ent.type=ig.Entity.TYPE.NONE;ent.checkAgainst=ig.Entity.TYPE.NONE;ent.collides=ig.Entity.COLLIDES.NEVER;this._deferredKill.push(ent);},run:function(){this.update();this.draw();},update:function(){if(this._levelToLoad){this.loadLevel(this._levelToLoad);this._levelToLoad=null;}
if(this._doSortEntities||this.autoSort){this.sortEntities();this._doSortEntities=false;}
this.updateEntities();this.checkEntities();for(var i=0;i<this._deferredKill.length;i++){this.entities.erase(this._deferredKill[i]);}
this._deferredKill=[];for(var tileset in this.backgroundAnims){var anims=this.backgroundAnims[tileset];for(var a in anims){anims[a].update();}}},updateEntities:function(){for(var i=0;i<this.entities.length;i++){var ent=this.entities[i];if(!ent._killed){ent.update();}}},draw:function(){if(this.clearColor){ig.system.clear(this.clearColor);}
this._rscreen.x=ig.system.getDrawPos(this.screen.x)/ig.system.scale;this._rscreen.y=ig.system.getDrawPos(this.screen.y)/ig.system.scale;var mapIndex;for(mapIndex=0;mapIndex<this.backgroundMaps.length;mapIndex++){var map=this.backgroundMaps[mapIndex];if(map.foreground){break;}
map.setScreenPos(this.screen.x,this.screen.y);map.draw();}
this.drawEntities();for(mapIndex;mapIndex<this.backgroundMaps.length;mapIndex++){var map=this.backgroundMaps[mapIndex];map.setScreenPos(this.screen.x,this.screen.y);map.draw();}},drawEntities:function(){for(var i=0;i<this.entities.length;i++){this.entities[i].draw();}},checkEntities:function(){var hash={};for(var e=0;e<this.entities.length;e++){var entity=this.entities[e];if(entity.type==ig.Entity.TYPE.NONE&&entity.checkAgainst==ig.Entity.TYPE.NONE&&entity.collides==ig.Entity.COLLIDES.NEVER){continue;}
var checked={},xmin=Math.floor(entity.pos.x/this.cellSize),ymin=Math.floor(entity.pos.y/this.cellSize),xmax=Math.floor((entity.pos.x+entity.size.x)/this.cellSize)+1,ymax=Math.floor((entity.pos.y+entity.size.y)/this.cellSize)+1;for(var x=xmin;x<xmax;x++){for(var y=ymin;y<ymax;y++){if(!hash[x]){hash[x]={};hash[x][y]=[entity];}
else if(!hash[x][y]){hash[x][y]=[entity];}
else{var cell=hash[x][y];for(var c=0;c<cell.length;c++){if(entity.touches(cell[c])&&!checked[cell[c].id]){checked[cell[c].id]=true;ig.Entity.checkPair(entity,cell[c]);}}
cell.push(entity);}}}}}});ig.Game.SORT={Z_INDEX:function(a,b){return a.zIndex-b.zIndex;},POS_X:function(a,b){return(a.pos.x+a.size.x)-(b.pos.x+b.size.x);},POS_Y:function(a,b){return(a.pos.y+a.size.y)-(b.pos.y+b.size.y);}};});

// lib/game/entities/player.js
ig.baked=true;ig.module('game.entities.player').requires('impact.entity').defines(function(){EntityPlayer=ig.Entity.extend({type:ig.Entity.TYPE.A,collides:ig.Entity.COLLIDES.PASSIVE,checkAgainst:ig.Entity.TYPE.B,lastVel:{},other:{},lastTouch:{},isTouchTrue:false,isFirstEaten:false,size:{x:177,y:180},currentSpeed:50,createEntity:{type:0,check:false},baseSpeed:35,currentAngle:0,animSheet:new ig.AnimationSheet('media/Animation2_new.png',177,180),temp:0,bounciness:1,isEatingInProgress:false,zIndex:1000,pixcaltype:"A",isTenEaten:false,killer:0,increamentvalue:0,allowlongpress:true,friction:{x:20,y:20},accel:{x:0,y:0},radius:[12,15,17,19,20,22,24,27,30,35,39,40,45,50,54,56,63,68],framesizearray:[{xi:77,yi:78,xf:101,yf:102},{xi:73,yi:75,xf:104,yf:104},{xi:71,yi:73,xf:108,yf:105},{xi:70,yi:70,xf:110,yf:106},{xi:70,yi:68,xf:111,yf:108},{xi:68,yi:66,xf:112,yf:110},{xi:65,yi:64,xf:114,yf:114},{xi:61,yi:62,xf:115,yf:116},{xi:59,yi:60,xf:120,yf:120},{xi:55,yi:54,xf:122,yf:125},{xi:49,yi:51,xf:127,yf:128},{xi:46,yi:50,xf:128,yf:130},{xi:44,yi:43,xf:131,yf:134},{xi:36,yi:40,xf:140,yf:138},{xi:34,yi:34,xf:141,yf:143},{xi:32,yi:32,xf:143,yf:145},{xi:23,yi:25,xf:150,yf:151},{xi:20,yi:20,xf:156,yf:157}],isGameEndActivated:false,init:function(x,y,settings){this.parent(x,y,settings);this.addAnim('idle1',0.2,[7]);this.addAnim('eating1',0.2,[2,3,4,5,6,7],true);this.addAnim('eating2',0.2,[10,11,12,13,14],true);this.addAnim('eating3',0.2,[17,18,19,20,21],true);this.addAnim('eating4',0.2,[24,25,26,27,28],true);this.addAnim('eating5',0.2,[31,32,33,34,35],true);this.addAnim('eating6',0.2,[36,37,38,39,40,41,42],true);this.addAnim('eating7',0.2,[43,44,45,46,47,48,49],true);this.addAnim('eating8',0.2,[50,51,52,53,54,55,56],true);this.addAnim('eating9',0.2,[57,58,59,60,61,62,63],true);this.addAnim('eating10',0.2,[64,65,66,67,68,69,70],true);this.addAnim('eating20',0.2,[71,72,73,74,75,76,77],true);this.addAnim('eating30',0.2,[78,79,80,81,82,83,84],true);this.addAnim('eating40',0.2,[85,86,87,88,89,90,91],true);this.addAnim('eating50',0.2,[92,93,94,95,96,97,98],true);this.addAnim('eating60',0.2,[99,100,101,102,103,104,105],true);this.addAnim('eating70',0.2,[106,107,108,109,110,111,112],true);this.addAnim('eating80',0.2,[113,114,115,116,117,118,119],true);this.addAnim('eating90',0.2,[120,121,122,123,124,125,126],true);this.vel.x=0;this.vel.y=0;this.maxVel.x=1000;this.maxVel.y=1000;},update:function(){if(ig.input.pressed('pull')){this.increamentvalue=0;this.allowlongpress=true;this.lastTouch.x=ig.input.mouse.x;this.lastTouch.y=ig.input.mouse.y;this.isTouchTrue=true;var tile=this.currentAnim.tile;var index=parseInt(tile/7);if(index==(tile/7)){index--;}
if(this.customDistanceTo({x:ig.input.mouse.x,y:ig.input.mouse.y})<=this.radius[index]){this.vel.x=0;this.vel.y=0;}else{this.isTouchTrue=true;var angle=this.customAngleTo(this.lastTouch);this.currentAngle=angle;this.currentSpeed=this.baseSpeed*parseInt(Math.round(this.customDistanceTo(this.lastTouch)/100,0));var x=Math.cos(angle);var y=Math.sin(angle);this.vel.x=x*this.currentSpeed;this.vel.y=y*this.currentSpeed;}
this.setFoodConsumedObject();}
if(ig.input.state('pull')){if(this.allowlongpress){var tile=this.currentAnim.tile;var index=parseInt(tile/7);if(index==(tile/7)){index--;}
if(Math.round(this.customDistanceTo(this.lastTouch)>this.radius[index])){var angle=this.customAngleTo(this.lastTouch);this.currentAngle=angle;this.currentSpeed=this.baseSpeed*(parseInt(Math.round(this.customDistanceTo(this.lastTouch)/100,0))+this.increamentvalue);this.increamentvalue+=0.15;var x=Math.cos(angle);var y=Math.sin(angle);this.vel.x=x*this.currentSpeed;this.vel.y=y*this.currentSpeed;}else{this.vel.x=0;this.vel.y=0;}
this.boundaryBounce(1);}else{this.boundaryBounce(2);}}else{this.boundaryBounce(2);}
if(this.isGameEndActivated){if(ig.game.between(this.pos.x+(this.size.x/2),(ig.system.width/2)-2,(ig.system.width/2)+2)&&ig.game.between(this.pos.y+(this.size.y/2),(ig.system.height/2)-2,(ig.system.height/2)+2))
{playGameComplete();this.isGameEndActivated=false;this.vel.x=0;this.vel.y=0;this.pos.x=(ig.system.width-this.animSheet.width)/2;this.pos.y=(ig.system.height-this.animSheet.height)/2;ig.game.gameEnd();}}
this.pushBackPlayer();this.parent();},setFoodConsumedObject:function(){if(typeof foodconsumed10!="undefined"&&foodconsumed10!=0){foodconsumed10.pos.x=this.pos.x+Math.floor(((this.size.x-foodconsumed10.size.x)/2));foodconsumed10.pos.y=this.pos.y+Math.floor(((this.size.y-foodconsumed10.size.y)/2));}
if(typeof foodconsumed1!="undefined"&&foodconsumed1!=0){foodconsumed1.pos.x=this.pos.x+Math.floor(((this.size.x-foodconsumed1.size.x)/2));foodconsumed1.pos.y=this.pos.y+Math.floor(((this.size.y-foodconsumed1.size.y)/2));}
if(typeof foodconsumed100!="undefined"&&foodconsumed100!=0){foodconsumed100.pos.x=this.pos.x+Math.floor(((this.size.x-foodconsumed100.size.x)/2));foodconsumed100.pos.y=this.pos.y+Math.floor(((this.size.y-foodconsumed100.size.y)/2));}},customAngleTo:function(cord){return Math.atan2((cord.y)-(this.pos.y+this.size.y/2),(cord.x)-(this.pos.x+this.size.x/2));},customDistanceTo:function(other){this.temp=(this.pos.x+this.size.x/2)-(other.x);var yd=(this.pos.y+this.size.y/2)-(other.y);return Math.floor(Math.sqrt(this.temp*this.temp+yd*yd));},getRandomInt:function(min,max){return Math.floor(Math.random()*(max-min+1))+min;},check:function(other){var tile=this.currentAnim.tile;var boolvalue=false;if(typeof other.radius!="undefined"&&typeof this.radius!="undefined"){var tile=this.currentAnim.tile;var index=parseInt(tile/7);if(index==(tile/7)){index--;}
radius1=other.radius;radius2=this.radius[index];if(this.distanceTo(other)>=(radius1+radius2))
{boolvalue=true;}}
if(boolvalue){}
else{if(!other.colision){return;}
if(tile%7!=0){return;}
setTimeout(function(){var globInteraction={"published":"2013-03-06T15:04:55Z","verb":"globInteraction","object":{"id":"123","gameLevel":_gameLevel,"objectType":"Play","placeValue":"10","resultValue":"20"},"actor":{"id":Setting["actor.id"]},"generator":{"appId":Setting["generator.appId"]},"target":{"objectType":"game","displayName":Setting["target.displayName"]}};globInteraction.object.placeValue=EatenGlobsList.toString();globInteraction.object.resultValue=ScoreAfterEaten.toString();globInteraction.published=getTimeStamp();if(typeof window.seer!='undefined')
window.seer.activity(globInteraction);},1);EatenGlobsList=other.worth;ScoreAfterEaten=ig.game.score+other.worth;if((ig.game.score+other.worth)==ig.game.levelDescription.level[(ig.game.CurrentLevel-1)].target||(ig.game.levelDescription.grandTotal+parseInt(other.worth))==ig.game.levelDescription.TotalScore)
{ig.game.hideCanvas();ig.input.unbind(ig.KEY.MOUSE1);}
if((ig.game.levelDescription.grandTotal+parseInt(other.worth))==ig.game.levelDescription.TotalScore){if(ig.ua.mobile)
document.addEventListener('touchstart',function(e){e.preventDefault();},false);}
this.lastVel.x=this.vel.x;this.lastVel.y=this.vel.y;this.vel.y=0;this.vel.x=0;this.allowlongpress=false;PlayCollision();ig.game.selectedGrid.erase(other.gridposition);ig.game.levelDescription.grandTotal=parseInt(other.worth)+ig.game.levelDescription.grandTotal;ig.game.score=parseInt(other.worth)+ig.game.score;if(ig.game.NumberOfOne==9&&(other.worth/global_score_control.multiplicationFactor)==1){this.isFirstEaten=true;}
if(ig.game.NumberOfTen==9&&(other.worth/global_score_control.multiplicationFactor)==10){this.isTenEaten=true;}
this.updateScoreVariables();this.temp=this.animationSheetChanger(ig.game.score,this);this.currentAnim=this.temp.rewind();other.kill();delete other;setTimeout(function(){var ply=ig.game.getEntityByName("player_organism");if(typeof ply!='undefined'&&ply!=null&&ply!='undefined'){ply.pushBackPlayer();}},1000);setTimeout(function(){var ply=ig.game.getEntityByName("player_organism");if(typeof ply!='undefined'&&ply!=null&&ply!='undefined'){if(ply.createEntity.check){if(ply.createEntity.type==10){ply.checkforCreation(10);}else if(ply.createEntity.type==1){ply.checkforCreation(1);}
else if(ply.createEntity.type==100){ply.checkforCreation(100);}}}},600);if(ig.game.score>0){if(ig.game.NumberOfTen>0){if(typeof foodconsumed10=="undefined"||foodconsumed10==0){this.createEntity.check=true;this.createEntity.type=10;}else{foodconsumed10.zIndex=10;foodconsumed10.currentAnim=this.switchScoreAnimationSheet(ig.game.NumberOfTen,foodconsumed10);foodconsumed10.pos.x=this.pos.x+Math.floor(((this.size.x-foodconsumed10.size.x)/2));foodconsumed10.pos.y=this.pos.y+Math.floor(((this.size.y-foodconsumed10.size.y)/2));}}
if(ig.game.NumberOfOne>0){if(typeof foodconsumed1=='undefined'||foodconsumed1==0){this.createEntity.type=1;this.createEntity.check=true;}
else{foodconsumed1.zIndex=100;foodconsumed1.currentAnim=this.switchScoreAnimationSheet(ig.game.NumberOfOne,foodconsumed1);foodconsumed1.pos.x=this.pos.x+Math.floor(((this.size.x-foodconsumed1.size.x)/2));foodconsumed1.pos.y=this.pos.y+Math.floor(((this.size.y-foodconsumed1.size.y)/2));}}
if(ig.game.NumberOfHundred>0){if(typeof foodconsumed100=='undefined'||foodconsumed100==0){this.createEntity.type=1;this.createEntity.check=true;}
else{foodconsumed100.zIndex=1;foodconsumed100.pos.x=this.pos.x+Math.floor(((this.size.x-foodconsumed100.size.x)/2));foodconsumed100.pos.y=this.pos.y+Math.floor(((this.size.y-foodconsumed100.size.y)/2));}}
else if(ig.game.NumberOfOne==0&&this.isFirstEaten){if(typeof foodconsumed1!='undefined'||foodconsumed1!=0){foodconsumed1.kill();delete foodconsumed1;foodconsumed1=0;this.isFirstEaten=false;}}
if(ig.game.NumberOfTen==0&&this.isTenEaten){if(typeof foodconsumed10!='undefined'||foodconsumed10!=0){foodconsumed10.kill();delete foodconsumed10;foodconsumed10=0;this.isTenEaten=false;this.createEntity.type=100;this.createEntity.check=true;}}}
ig.game.updateGameVariables();ig.game.checkScreenForSmallFood();}
this.parent();},collideWith:function(other,axis){this.collides=ig.Entity.COLLIDES.PASSIVE;this.setFoodConsumedObject();},animationSheetChanger:function(number,obj){var ab=number/global_score_control.multiplicationFactor;switch(ab){case 1:return obj.anims.eating1;break;case 2:return obj.anims.eating2;break;case 3:return obj.anims.eating3;break;case 4:return obj.anims.eating4;break;case 5:return obj.anims.eating5;break;case 6:return obj.anims.eating6;break;case 7:return obj.anims.eating7;break;case 8:return obj.anims.eating8;break;case 9:return obj.anims.eating9;break;case 10:case 11:case 12:case 13:case 14:case 15:case 16:case 17:case 18:case 19:return obj.anims.eating10;break;case 20:case 21:case 22:case 23:case 24:case 25:case 26:case 27:case 28:case 29:return obj.anims.eating20;break;case 30:case 31:case 32:case 33:case 34:case 35:case 36:case 37:case 38:case 39:return obj.anims.eating30;break;case 40:case 41:case 42:case 43:case 44:case 45:case 46:case 47:case 48:case 49:return obj.anims.eating40;break;case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:case 58:case 59:return obj.anims.eating50;break;case 60:case 61:case 62:case 63:case 64:case 65:case 66:case 67:case 68:case 69:return obj.anims.eating60;break;case 70:case 71:case 72:case 73:case 74:case 75:case 76:case 77:case 78:case 79:return obj.anims.eating70;break;case 80:case 81:case 82:case 83:case 84:case 85:case 86:case 87:case 88:case 89:return obj.anims.eating80;break;case 90:case 91:case 92:case 93:case 94:case 95:case 96:case 97:case 98:case 99:return obj.anims.eating90;break;default:return obj.anims.eating1;}},switchScoreAnimationSheet:function(number,obj){switch(number){case 1:return obj.anims.score1;break;case 2:return obj.anims.score2;break;case 3:return obj.anims.score3;break;case 4:return obj.anims.score4;break;case 5:return obj.anims.score5;break;case 6:return obj.anims.score6;break;case 7:return obj.anims.score7;break;case 8:return obj.anims.score8;break;case 9:return obj.anims.score9;break;default:return obj.anims.score1;}},boundaryBounce:function(flag){if(this.pos.x<=0)
{var tile=this.currentAnim.tile;var index=parseInt(tile/7);if(index==(tile/7)){index--;}
if(this.pos.x<=-(this.framesizearray[index].xi)){var other={pos:{x:this.pos.x,y:this.pos.y},vel:{x:0,y:0},size:{x:0,y:0}};var week=this;ig.Entity.seperateOnXAxis(other,this,week);if(flag==1){this.pushBackPlayer();this.allowlongpress=false;}
this.setFoodConsumedObject();}}
if(this.pos.x+this.size.x>=ig.system.width)
{var tile=this.currentAnim.tile;var index=parseInt(tile/7);if(index==(tile/7)){index--;}
if(this.pos.x+this.size.x>=(ig.system.width+(this.size.x-this.framesizearray[index].xf))){var other={pos:{x:this.pos.x+this.size.x,y:this.pos.y},vel:{x:0,y:0},size:{x:0,y:0}};var week=this;ig.Entity.seperateOnXAxis(this,other,week);if(flag==1&&this.allowlongpress){this.pushBackPlayer();this.allowlongpress=false;}
this.pushBackPlayer();this.setFoodConsumedObject();}}
if(this.pos.y<=0)
{var tile=this.currentAnim.tile;var index=parseInt(tile/7);if(index==(tile/7)){index--;}
if(this.pos.y<=-(this.framesizearray[index].yi))
{var other={pos:{x:this.pos.x,y:this.pos.y},vel:{x:0,y:0},size:{x:0,y:0}}
var week=this;ig.Entity.seperateOnYAxis(other,this,week);if(flag==1){this.pushBackPlayer();this.allowlongpress=false;}
this.setFoodConsumedObject();}}
if(this.pos.y+this.size.y>=ig.system.height)
{var tile=this.currentAnim.tile;var index=parseInt(tile/7);if(index==(tile/7)){index--;}
if(this.pos.y+this.size.y>=(ig.system.height+(this.size.y-this.framesizearray[index].yf)))
{var other={pos:{x:this.pos.x,y:this.pos.y+this.size.y},vel:{x:0,y:0},size:{x:0,y:0}}
var week=this;ig.Entity.seperateOnYAxis(this,other,week);if(flag==1){this.pushBackPlayer();this.allowlongpress=false;}
this.setFoodConsumedObject();}}},pushBackPlayer:function(){var ply=ig.game.getEntityByName("player_organism");if(typeof ply!='undefined'&&ply!=null&&ply!='undefined'){var tile=ply.currentAnim.tile;var index=parseInt(tile/7);if(index==(tile/7)){index--;}
if(ply.pos.x<=0)
{var tile=ply.currentAnim.tile;var index=parseInt(tile/7);if(index==(tile/7)){index--;}
if(ply.pos.x<=-(ply.framesizearray[index].xi)){ply.pos.x=-(ply.size.x/2-ply.radius[index])+15
ply.setFoodConsumedObject();}}
if(ply.pos.x+ply.size.x>=ig.system.width)
{var tile=ply.currentAnim.tile;var index=parseInt(tile/7);if(index==(tile/7)){index--;}
if(ply.pos.x+ply.size.x>=(ig.system.width+(ply.size.x-ply.framesizearray[index].xf))){ply.pos.x=ig.system.width-(ply.size.x/2+ply.radius[index])-15;ply.setFoodConsumedObject();}}
if(ply.pos.y<=0)
{var tile=ply.currentAnim.tile;var index=parseInt(tile/7);if(index==(tile/7)){index--;}
if(ply.pos.y<=-(ply.framesizearray[index].yi))
{ply.pos.y=-(ply.size.y/2-ply.radius[index])+15;ply.setFoodConsumedObject();}}
if(ply.pos.y+ply.size.y>=ig.system.height)
{var tile=ply.currentAnim.tile;var index=parseInt(tile/7);if(index==(tile/7)){index--;}
if(ply.pos.y+ply.size.y>=(ig.system.height+(ply.size.y-ply.framesizearray[index].yf)))
{ply.pos.y=ig.system.height-(ply.size.y/2+ply.radius[index])-15;ply.setFoodConsumedObject();}}}},checkforCreation:function(number){if(number==10){foodconsumed10=ig.game.spawnEntity(EntityFoodConsumed10,this.pos.x,this.pos.y,{name:"foodconsumed10"});foodconsumed10.zIndex=10;ig.game.sortEntitiesDeferred();foodconsumed10.pos.x=this.pos.x+Math.floor(((this.size.x-foodconsumed10.size.x)/2));foodconsumed10.pos.y=this.pos.y+Math.floor(((this.size.y-foodconsumed10.size.y)/2));}
else if(number==1){foodconsumed1=ig.game.spawnEntity(EntityFoodConsumed1,this.pos.x,this.pos.y,{name:"foodconsumed1"});foodconsumed1.zIndex=100;ig.game.sortEntitiesDeferred();foodconsumed1.pos.x=this.pos.x+Math.floor(((this.size.x-foodconsumed1.size.x)/2));foodconsumed1.pos.y=this.pos.y+Math.floor(((this.size.y-foodconsumed1.size.y)/2));}
else if(number==100){foodconsumed100=ig.game.spawnEntity(EntityFoodConsumed100,this.pos.x,this.pos.y,{name:"foodconsumed100"});foodconsumed100.zIndex=5;ig.game.sortEntitiesDeferred();foodconsumed100.pos.x=this.pos.x+Math.floor(((this.size.x-foodconsumed100.size.x)/2));foodconsumed100.pos.y=this.pos.y+Math.floor(((this.size.y-foodconsumed100.size.y)/2));}
this.createEntity.check=false;},updateScoreVariables:function(){ig.game.NumberOfHundred=parseInt(ig.game.score/global_score_control.worth_maximum_limit_ball);ig.game.NumberOfTen=parseInt((ig.game.score-(ig.game.NumberOfHundred*global_score_control.worth_maximum_limit_ball))/global_score_control.worth_big_ball);ig.game.NumberOfOne=parseInt((ig.game.score-(ig.game.NumberOfHundred*global_score_control.worth_maximum_limit_ball+ig.game.NumberOfTen*global_score_control.worth_big_ball))/global_score_control.worth_small_ball);}});});

// lib/game/entities/ball1.js
ig.baked=true;ig.module('game.entities.ball1').requires('impact.entity').defines(function(){EntityBall1=ig.Entity.extend({type:ig.Entity.TYPE.B,pixcaltype:"B",collides:ig.Entity.COLLIDES.PASSIVE,size:{x:12,y:11},worth:global_score_control.getWorth(1),mass:1,animSheet:new ig.AnimationSheet('media/1.png',12,11),bounciness:2,temp:0,speed:15,zIndex:2,life:300,colision:true,radius:6,checkAgainst:ig.Entity.TYPE.BOTH,init:function(x,y,settings){this.parent(x,y,settings);this.addAnim('idle',1,[0]);this.temp=this.getRandomMovement();this.vel.x=this.temp[0];this.vel.y=this.temp[1];},customAngleTo:function(cord){return Math.atan2((cord.y)-(this.pos.y+this.size.y/2),(cord.x)-(this.pos.x+this.size.x/2));},customDistanceTo:function(other){this.temp=(this.pos.x+this.size.x/2)-(other.x);var yd=(this.pos.y+this.size.y/2)-(other.y);return Math.sqrt(this.temp*this.temp+yd*yd);},check:function(other){if((other.pixcaltype=="A")){return false;}else{other.collides=ig.Entity.COLLIDES.ACTIVE;}
this.parent();},collideWith:function(other,axis){other.collides=ig.Entity.COLLIDES.PASSIVE;},update:function(){if(this.checkPosition()){ig.game.selectedGrid.erase(this.gridposition);this.kill();delete this;ig.game.checkScreenForSmallFood();}
if(ig.game.isfadeOutActivated||this.BustingKillOptionChecked){if(this.scalecount==0){ig.game.selectedGrid.erase(this.gridposition);this.kill();delete this;ig.game.isfadeOutActivated=false;}else if(this.scalecount%7==0){this.setScale(this.scalecount/70,this.scalecount/70);}
this.scalecount--;}
if(this.isInitialScale){if(this.growCounter==45){this.isInitialScale=false;this.setScale(1,1);}else{this.initialScaleValue=this.initialScaleValue+.02;this.growCounter++;this.setScale(this.initialScaleValue,this.initialScaleValue);}}
this.parent();},growCounter:0,scalecount:70,initialScaleValue:0.1,isInitialScale:false,getRandomMovement:function(){this.temp=this.customAngleTo(ig.game.canvasCenter)
var x=Math.cos(this.temp-ig.game.getRandomInt(0,Math.PI));var y=Math.sin(this.temp-ig.game.getRandomInt(0,Math.PI));return[x*this.speed,y*this.speed];},getBustingRandom:function(){var randomSelection=Math.round(Math.random()*3);var randomDirection;switch(randomSelection){case 0:randomDirection={'x':0,'y':0};break;case 1:randomDirection={'x':ig.system.width,'y':0};break;case 2:randomDirection={'x':0,'y':ig.system.height};break;case 3:randomDirection={'x':ig.system.width,'y':ig.system.height};break;}
this.temp=this.customAngleTo(randomDirection)
var x=Math.cos(this.temp-ig.game.getRandomInt(0,Math.PI));var y=Math.sin(this.temp-ig.game.getRandomInt(0,Math.PI));return[x*this.speed,y*this.speed];},getRandomInt:function(min,max){return Math.floor(Math.random()*(max-min+1))+min;},checkPosition:function(){if(this.pos.x<-100||this.pos.x>ig.system.width+50||this.pos.y<-100||this.pos.y>ig.system.height+50){return true;}},getOuterRandomMotion:function(){this.temp=this.customAngleTo([ig.game.canvasCenter.x+this.getRandomInt(0,50),ig.game.canvasCenter.y+this.getRandomInt(0,50)])
var x=Math.cos(this.temp);var y=Math.sin(thi.temp);return[x*this.speed,y*this.speed];},getInnerRandomMotion:function(){this.temp=this.customAngleTo([ig.game.getRandomInt(0,1000),ig.game.getRandomInt(0,580)])
var x=Math.cos(this.temp-ig.game.getRandomInt(0,Math.PI));var y=Math.sin(this.temp-ig.game.getRandomInt(0,Math.PI));return[x*this.speed,y*this.speed];},between:function(x,min,max){if(x>=min&&x<=max)
return true;else
return false;},});});

// lib/game/entities/ball10.js
ig.baked=true;ig.module('game.entities.ball10').requires('impact.entity').defines(function(){EntityBall10=ig.Entity.extend({type:ig.Entity.TYPE.B,pixcaltype:"B",collides:ig.Entity.COLLIDES.PASSIVE,size:{x:57,y:50},animSheet:new ig.AnimationSheet('media/10.png',57,50),bounciness:1,mass:2,zIndex:2,life:300,worth:global_score_control.getWorth(2),radius:27,BustingKillOptionChecked:false,temp:0,speed:7,colision:true,checkAgainst:ig.Entity.TYPE.BOTH,init:function(x,y,settings){this.parent(x,y,settings);this.addAnim('idle',1,[0]);this.temp=this.getRandomMovement();this.vel.x=this.temp[0];this.vel.y=this.temp[1];},customAngleTo:function(cord){return Math.atan2((cord.y)-(this.pos.y+this.size.y/2),(cord.x)-(this.pos.x+this.size.x/2));},customDistanceTo:function(other){this.temp=(this.pos.x+this.size.x/2)-(other.x);var yd=(this.pos.y+this.size.y/2)-(other.y);return Math.sqrt(this.temp*this.temp+yd*yd);},check:function(other){if((other.pixcaltype=="A")){return false;}else{other.collides=ig.Entity.COLLIDES.ACTIVE;}
this.parent();},collideWith:function(other,axis){other.collides=ig.Entity.COLLIDES.PASSIVE;},update:function(){if(this.checkPosition()){ig.game.selectedGrid.erase(this.gridposition);this.kill();delete this;ig.game.checkScreenForSmallFood();}
if(ig.game.isfadeOutActivated||this.BustingKillOptionChecked){if(this.scalecount==0){ig.game.selectedGrid.erase(this.gridposition);this.kill();delete this;ig.game.isfadeOutActivated=false;}else if(this.scalecount%7==0){this.setScale(this.scalecount/70,this.scalecount/70);}
this.scalecount--;}
if(this.isInitialScale){if(this.growCounter==45){this.isInitialScale=false;this.setScale(1,1);}else{this.growCounter++;this.initialScaleValue=this.initialScaleValue+0.02;this.setScale(this.initialScaleValue,this.initialScaleValue);}}
this.parent();},scalecount:70,initialScaleValue:0.1,isInitialScale:false,growCounter:0,getRandomMovement:function(){this.temp=this.customAngleTo(ig.game.canvasCenter)
var x=Math.cos(this.temp);var y=Math.sin(this.temp);return[x*this.speed,y*this.speed];},getBustingRandom:function(){var randomSelection=Math.round(Math.random()*3);var randomDirection;switch(randomSelection){case 0:randomDirection={'x':0,'y':0};break;case 1:randomDirection={'x':ig.system.width,'y':0};break;case 2:randomDirection={'x':0,'y':ig.system.height};break;case 3:randomDirection={'x':ig.system.width,'y':ig.system.height};break;}
this.temp=this.customAngleTo(randomDirection)
var x=Math.cos(this.temp-ig.game.getRandomInt(0,Math.PI));var y=Math.sin(this.temp-ig.game.getRandomInt(0,Math.PI));return[x*this.speed,y*this.speed];},getRandomInt:function(min,max){return Math.floor(Math.random()*(max-min+1))+min;},getInnerRandomMotion:function(){this.temp=this.customAngleTo([ig.game.getRandomInt(0,1000),ig.game.getRandomInt(0,580)])
var x=Math.cos(this.temp-ig.game.getRandomInt(0,Math.PI));var y=Math.sin(this.temp-ig.game.getRandomInt(0,Math.PI));return[x*this.speed,y*this.speed];},getOuterRandomMotion:function(){this.temp=this.customAngleTo([ig.game.canvasCenter.x+this.getRandomInt(0,50),ig.game.canvasCenter.y+this.getRandomInt(0,50)])
var x=Math.cos(this.temp);var y=Math.sin(this.temp);return[x*this.speed,y*this.speed];},checkPosition:function(){if(this.pos.x<-100||this.pos.x>ig.system.width+50||this.pos.y<-100||this.pos.y>ig.system.height+50){return true;}},});});

// lib/game/entities/foodconsumed10.js
ig.baked=true;ig.module('game.entities.foodconsumed10').requires('impact.entity').defines(function(){EntityFoodConsumed10=ig.Entity.extend({collides:ig.Entity.COLLIDES.NEVER,type:ig.Entity.TYPE.NONE,checkAgainst:ig.Entity.TYPE.NONE,pixcaltype:"ignore",size:{x:125,y:110},animSheet:new ig.AnimationSheet('media/10-90.png',125,110),bounciness:1,temp:0,init:function(x,y,settings){this.parent(x,y,settings);this.addAnim('score1',1,[0]);this.addAnim('score2',1,[1]);this.addAnim('score3',1,[2]);this.addAnim('score4',1,[3]);this.addAnim('score5',1,[4]);this.addAnim('score6',1,[5]);this.addAnim('score7',1,[6]);this.addAnim('score8',1,[7]);this.addAnim('score9',1,[8]);this.maxVel.x=500;this.maxVel.y=500;},update:function(){this.temp=ig.game.getEntityByName("player_organism");if(typeof this.temp!='undefined'&&this.temp!=null&&this.temp!='undefined'){this.vel.x=this.temp.vel.x;this.vel.y=this.temp.vel.y;this.pos.x=this.temp.pos.x+Math.floor(((this.temp.size.x-this.size.x)/2));this.pos.y=this.temp.pos.y+Math.floor(((this.temp.size.y-this.size.y)/2));}
this.parent();}});});

// lib/game/entities/foodconsumed1.js
ig.baked=true;ig.module('game.entities.foodconsumed1').requires('impact.entity').defines(function(){EntityFoodConsumed1=ig.Entity.extend({collides:ig.Entity.COLLIDES.NEVER,type:ig.Entity.TYPE.NONE,checkAgainst:ig.Entity.TYPE.NONE,pixcaltype:"ignore",size:{x:48,y:41},animSheet:new ig.AnimationSheet('media/1-9.png',48,41),bounciness:1,temp:0,init:function(x,y,settings){this.parent(x,y,settings);this.addAnim('score1',1,[0]);this.addAnim('score2',1,[1]);this.addAnim('score3',1,[2]);this.addAnim('score4',1,[3]);this.addAnim('score5',1,[4]);this.addAnim('score6',1,[5]);this.addAnim('score7',1,[6]);this.addAnim('score8',1,[7]);this.addAnim('score9',1,[8]);this.maxVel.x=500;this.maxVel.y=500;},update:function(){this.temp=ig.game.getEntityByName("player_organism");if(typeof this.temp!='undefined'&&this.temp!=null&&this.temp!='undefined'){this.vel.x=this.temp.vel.x;this.vel.y=this.temp.vel.y;this.pos.x=this.temp.pos.x+Math.floor(((this.temp.size.x-this.size.x)/2));this.pos.y=this.temp.pos.y+Math.floor(((this.temp.size.y-this.size.y)/2));}
this.parent();}});});

// lib/game/entities/foodconsumed100.js
ig.baked=true;ig.module('game.entities.foodconsumed100').requires('impact.entity').defines(function(){EntityFoodConsumed100=ig.Entity.extend({collides:ig.Entity.COLLIDES.NEVER,type:ig.Entity.TYPE.NONE,checkAgainst:ig.Entity.TYPE.NONE,pixcaltype:"ignore",size:{x:142,y:125},animSheet:new ig.AnimationSheet('media/100.png',142,125),bounciness:1,worth:global_score_control.getWorth(3),temp:0,init:function(x,y,settings){this.parent(x,y,settings);this.addAnim('idle',1,[0]);this.maxVel.x=500;this.maxVel.y=500;},update:function(){this.temp=ig.game.getEntityByName("player_organism");this.vel.x=this.temp.vel.x;this.vel.y=this.temp.vel.y;this.parent();}});});

// lib/game/entities/busting.js
ig.baked=true;ig.module('game.entities.busting').requires('impact.entity').defines(function(){Entitybust=ig.Entity.extend({size:{x:182,y:185},animSheet:new ig.AnimationSheet('media/Burst6_01-09.png',189,189),animSheet2:new ig.AnimationSheet('media/Burst6_10-90.png',189,189),zIndex:1000,addAnim:function(name,frameTime,sequence,stop,SheetToUse){if(typeof(SheetToUse)=="undefined"){SheetToUse=this.animSheet;}
var a=new ig.Animation(SheetToUse,frameTime,sequence,stop);this.anims[name]=a;if(!this.currentAnim){this.currentAnim=a;}
return a;},init:function(x,y,settings){this.parent(x,y,settings);this.addAnim('busting1',0.1,[1,2,3,4,5,7,8,9],true);this.addAnim('busting2',0.1,[10,11,12,13,14,15,16,17,18],true);this.addAnim('busting3',0.1,[19,20,21,22,23,24,25,26,27],true);this.addAnim('busting4',0.1,[28,29,30,31,32,33,34,35,36],true);this.addAnim('busting5',0.1,[37,38,39,40,41,42,43,44,45],true);this.addAnim('busting6',0.1,[46,47,48,49,50,51,52,53,54],true);this.addAnim('busting7',0.1,[55,56,57,58,59,60,61,62,63],true);this.addAnim('busting8',0.1,[64,65,66,67,68,69,70,71,72],true);this.addAnim('busting9',0.1,[73,74,75,76,77,78,79,80,81,82],true);this.addAnim('busting10',0.1,[1,2,3,4,5,7,8,9],true,this.animSheet2);this.addAnim('busting20',0.1,[10,11,12,13,14,15,16,17,18],true,this.animSheet2);this.addAnim('busting30',0.1,[19,20,21,22,23,24,25,26,27],true,this.animSheet2);this.addAnim('busting40',0.1,[28,29,30,31,32,33,34,35,36],true,this.animSheet2);this.addAnim('busting50',0.1,[37,38,39,40,41,42,43,44,45],true,this.animSheet2);this.addAnim('busting60',0.1,[46,47,48,49,50,51,52,53,54],true,this.animSheet2);this.addAnim('busting70',0.1,[55,56,57,58,59,60,61,62,63],true,this.animSheet2);this.addAnim('busting80',0.1,[64,65,66,67,68,69,70,71,72],true,this.animSheet2);this.addAnim('busting90',0.1,[73,74,75,76,77,78,79,80,81,82],true,this.animSheet2);this.vel.x=0;this.vel.y=0;},changeAnimationSheet:function(number,obj){var aa=parseInt(number/global_score_control.multiplicationFactor);switch(aa){case 1:return obj.anims.busting1;break;case 2:return obj.anims.busting2;break;case 3:return obj.anims.busting3;break;case 4:return obj.anims.busting4;break;case 5:return obj.anims.busting5;break;case 6:return obj.anims.busting6;break;case 7:return obj.anims.busting7;break;case 8:return obj.anims.busting8;break;case 9:return obj.anims.busting9;break;case 10:case 11:case 12:case 13:case 14:case 15:case 16:case 17:case 18:case 19:return obj.anims.busting10;break;case 20:case 21:case 22:case 23:case 24:case 25:case 26:case 27:case 28:case 29:return obj.anims.busting20;break;case 30:case 31:case 32:case 33:case 34:case 35:case 36:case 37:case 38:case 39:return obj.anims.busting30;break;case 40:case 41:case 42:case 43:case 44:case 45:case 46:case 47:case 48:case 49:return obj.anims.busting40;break;case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:case 58:case 59:return obj.anims.busting50;break;case 60:case 61:case 62:case 63:case 64:case 65:case 66:case 67:case 68:case 69:return obj.anims.busting60;break;case 70:case 71:case 72:case 73:case 74:case 75:case 76:case 77:case 78:case 79:return obj.anims.busting70;break;case 80:case 81:case 82:case 83:case 84:case 85:case 86:case 87:case 88:case 89:return obj.anims.busting80;break;case 90:case 91:case 92:case 93:case 94:case 95:case 96:case 97:case 98:case 99:return obj.anims.busting90;break;default:return obj.anims.busting1;}},check:function(other){return false;},update:function(){this.parent();}});});

// lib/game/entities/reward.js
ig.baked=true;ig.module('game.entities.reward').requires('impact.entity').defines(function(){Entityreward=ig.Entity.extend({size:{x:183,y:183},animSheet:new ig.AnimationSheet('media/Animation_reward_new2.png',183,183),zIndex:10000,init:function(x,y,settings){this.parent(x,y,settings);this.addAnim('idle1',0.1,[5]);this.addAnim('reward1',0.2,[0,1,2,3,4,5],true);this.addAnim('idle2',0.1,[9]);this.addAnim('reward2',0.2,[6,7,8,9,10,11],true);this.addAnim('idle3',0.1,[13]);this.addAnim('reward3',0.2,[12,13,14,15,16,17],true);this.addAnim('idle4',0.1,[17]);this.addAnim('reward4',0.2,[18,19,20,21,22,23],true);this.addAnim('idle5',0.1,[21]);this.addAnim('reward5',0.2,[24,25,26,27,28,29],true);this.addAnim('idle6',0.1,[25]);this.addAnim('reward6',0.2,[30,31,32,33,34,35,36],true);this.addAnim('idle7',0.1,[29]);this.addAnim('reward7',0.2,[37,38,39,40,41,42,43],true);this.addAnim('idle8',0.1,[33]);this.addAnim('reward8',0.2,[44,45,46,47,48,49,50],true);this.addAnim('idle9',0.1,[37]);this.addAnim('reward9',0.2,[51,52,53,54,55,56,57],true);this.addAnim('idle10',0.1,[41]);this.addAnim('reward10',0.2,[58,59,60,61,62,63,64],true);this.addAnim('idle20',0.1,[45]);this.addAnim('reward20',0.3,[65,66,67,68,69,70,71],true);this.addAnim('idle30',0.1,[49]);this.addAnim('reward30',0.3,[72,73,74,75,76,77,78],true);this.addAnim('idle40',0.1,[53]);this.addAnim('reward40',0.2,[79,80,81,82,83,84,85],true);this.addAnim('idle50',0.1,[57]);this.addAnim('reward50',0.2,[86,87,88,89,90,91,92],true);this.addAnim('idle60',0.1,[61]);this.addAnim('reward60',0.2,[93,94,95,96,97,98,99],true);this.addAnim('idle70',0.1,[65]);this.addAnim('reward70',0.2,[100,101,102,103,104,105,106],true);this.addAnim('idle80',0.1,[69]);this.addAnim('reward80',0.2,[107,108,109,110,111,112,113],true);this.addAnim('idle90',0.1,[73]);this.addAnim('reward90',0.2,[114,115,116,117,118,119,120],true);this.vel.x=0;this.vel.y=0;},changeRewardAnimationSheet:function(number,obj){var aa=parseInt(number/global_score_control.multiplicationFactor);switch(aa){case 1:return obj.anims.reward1;break;case 2:return obj.anims.reward2;break;case 3:return obj.anims.reward3;break;case 4:return obj.anims.reward4;break;case 5:return obj.anims.reward5;break;case 6:return obj.anims.reward6;break;case 7:return obj.anims.reward7;break;case 8:return obj.anims.reward8;break;case 9:return obj.anims.reward9;break;case 10:case 11:case 12:case 13:case 14:case 15:case 16:case 17:case 18:case 19:return obj.anims.reward10;break;case 20:case 21:case 22:case 23:case 24:case 25:case 26:case 27:case 28:case 29:return obj.anims.reward20;break;case 30:case 31:case 32:case 33:case 34:case 35:case 36:case 37:case 38:case 39:return obj.anims.reward30;break;case 40:case 41:case 42:case 43:case 44:case 45:case 46:case 47:case 48:case 49:return obj.anims.reward40;break;case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:case 58:case 59:return obj.anims.reward50;break;case 60:case 61:case 62:case 63:case 64:case 65:case 66:case 67:case 68:case 69:return obj.anims.reward60;break;case 70:case 71:case 72:case 73:case 74:case 75:case 76:case 77:case 78:case 79:return obj.anims.reward70;break;case 80:case 81:case 82:case 83:case 84:case 85:case 86:case 87:case 88:case 89:return obj.anims.reward80;break;case 90:case 91:case 92:case 93:case 94:case 95:case 96:case 97:case 98:case 99:return obj.anims.reward90;break;default:return obj.anims.reward1;}},check:function(other){return false;},update:function(){this.parent();}});});

// lib/plugins/scale.js
ig.baked=true;ig.module('plugins.scale').requires('impact.entity').defines(function(){ig.Entity.inject({scale:{x:1,y:1},_offset:{x:0,y:0},_scale:{x:1,y:1},_size:{x:0,y:0},init:function(x,y,settings){this.parent(x,y,settings);this._offset.x=this.offset.x;this._offset.y=this.offset.y;this._size.x=this.size.x;this._size.y=this.size.y;this.setScale(this.scale.x,this.scale.y);},draw:function(){var ctx=ig.system.context;ctx.save();ctx.translate(ig.system.getDrawPos(this.pos.x.round()-this.offset.x-ig.game.screen.x),ig.system.getDrawPos(this.pos.y.round()-this.offset.y-ig.game.screen.y));ctx.scale(this._scale.x,this._scale.y);this.currentAnim.draw(0,0);ctx.restore();},setScale:function(x,y){var oX=this.size.x,oY=this.size.y;this.scale.x=x||this.scale.x;this.scale.y=y||this.scale.y;this._scale.x=this.scale.x/ig.system.scale;this._scale.y=this.scale.y/ig.system.scale;this.offset.x=this._offset.x*this._scale.x;this.offset.y=this._offset.y*this._scale.y;this.size.x=this._size.x*this._scale.x;this.size.y=this._size.y*this._scale.y;this.pos.x+=oX-this.size.x;this.pos.y+=oY-this.size.y;}});});

// lib/game/entities/reward_second.js
ig.baked=true;ig.module('game.entities.reward_second').requires('impact.entity').defines(function(){Entityreward_two=ig.Entity.extend({collides:ig.Entity.COLLIDES.NEVER,type:ig.Entity.TYPE.NONE,checkAgainst:ig.Entity.TYPE.NONE,size:{x:183,y:183},animSheet:new ig.AnimationSheet('media/Animation_edge_glow.png',183,183),zIndex:10000,init:function(x,y,settings){this.parent(x,y,settings);this.addAnim('reward1',0.2,[0],true);this.addAnim('reward2',0.2,[1],true);this.addAnim('reward3',0.2,[2],true);this.addAnim('reward4',0.2,[3],true);this.addAnim('reward5',0.2,[4],true);this.addAnim('reward6',0.2,[5],true);this.addAnim('reward7',0.2,[6],true);this.addAnim('reward8',0.2,[7],true);this.addAnim('reward9',0.2,[8],true);this.addAnim('reward10',0.2,[9],true);this.addAnim('reward20',0.2,[10],true);this.addAnim('reward30',0.2,[11],true);this.addAnim('reward40',0.2,[12],true);this.addAnim('reward50',0.2,[13],true);this.addAnim('reward60',0.2,[14],true);this.addAnim('reward70',0.2,[15],true);this.addAnim('reward80',0.2,[16],true);this.addAnim('reward90',0.2,[17],true);this.vel.x=0;this.vel.y=0;},changeRewardAnimationSheet:function(number,obj){var aa=parseInt(number/global_score_control.multiplicationFactor);switch(aa){case 1:return obj.anims.reward1;break;case 2:return obj.anims.reward2;break;case 3:return obj.anims.reward3;break;case 4:return obj.anims.reward4;break;case 5:return obj.anims.reward5;break;case 6:return obj.anims.reward6;break;case 7:return obj.anims.reward7;break;case 8:return obj.anims.reward8;break;case 9:return obj.anims.reward9;break;case 10:case 11:case 12:case 13:case 14:case 15:case 16:case 17:case 18:case 19:return obj.anims.reward10;break;case 20:case 21:case 22:case 23:case 24:case 25:case 26:case 27:case 28:case 29:return obj.anims.reward20;break;case 30:case 31:case 32:case 33:case 34:case 35:case 36:case 37:case 38:case 39:return obj.anims.reward30;break;case 40:case 41:case 42:case 43:case 44:case 45:case 46:case 47:case 48:case 49:return obj.anims.reward40;break;case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:case 58:case 59:return obj.anims.reward50;break;case 60:case 61:case 62:case 63:case 64:case 65:case 66:case 67:case 68:case 69:return obj.anims.reward60;break;case 70:case 71:case 72:case 73:case 74:case 75:case 76:case 77:case 78:case 79:return obj.anims.reward70;break;case 80:case 81:case 82:case 83:case 84:case 85:case 86:case 87:case 88:case 89:return obj.anims.reward80;break;case 90:case 91:case 92:case 93:case 94:case 95:case 96:case 97:case 98:case 99:return obj.anims.reward90;break;default:return obj.anims.reward1;}},check:function(other){return false;},update:function(){this.parent();}});});

// lib/game/entities/endanimation.js
ig.baked=true;ig.module('game.entities.endanimation').requires('impact.entity').defines(function(){Entityendanimation=ig.Entity.extend({collides:ig.Entity.COLLIDES.PASSIVE,type:ig.Entity.TYPE.NONE,pixcaltype:"ignore",size:{x:225,y:226},animSheet:new ig.AnimationSheet('media/Math_end.png',225,226),bounciness:1,temp:0,lastTile:48,init:function(x,y,settings){this.parent(x,y,settings);this.addAnim('endanim',.2,[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16]);this.addAnim('after_glow',.1,[17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48])
this.maxVel.x=500;this.maxVel.y=500;},update:function(){if(this.currentAnim.tile==16)
{this.setScale(1,1);this.pos.x=Math.floor((ig.system.width-this.size.x)/2);this.pos.y=Math.floor((ig.system.height-this.size.y)/2);this.currentAnim=this.anims.after_glow;ig.game.killConsumedFoodEntity();ig.game.cleanScreen();}
if(this.currentAnim.tile==this.lastTile){this.kill();var ll=new EntitytextBoxAnimation();var nn=ig.game.spawnEntity(EntitytextBoxAnimation,(ig.system.width-ll.size.x)/2,(ig.system.height-ll.size.y)/2,{name:"textBox"});nn.setScale(.1,.1);}
if(this.currentAnim.tile<16){this.scaleCount++;if(!this.isScaleTrigger)
{this.scaleCountFadeIn=this.scaleCountFadeIn+1;this.setScale(this.scaleCountFadeIn/50,this.scaleCountFadeIn/50);this.pos.x=Math.floor((ig.system.width-this.size.x)/2);this.pos.y=Math.floor((ig.system.height-this.size.y)/2);if(this.scaleCount==100){this.isScaleTrigger=true;}}
else if(this.isScaleTrigger&&this.isCompletedScale){this.scaleCountFadeIn=this.scaleCountFadeIn-1;if((this.scaleCountFadeIn/50)>=1){this.setScale(this.scaleCountFadeIn/50,this.scaleCountFadeIn/50);this.pos.x=Math.floor((ig.system.width-this.size.x)/2);this.pos.y=Math.floor((ig.system.height-this.size.y)/2);}
if(this.scaleCount==200){this.isCompletedScale=false;}}}
this.parent();},isCompletedScale:true,scaleCountFadeIn:0,scaleCount:0,isScaleTrigger:false});});

// lib/game/entities/textBoxAnimation.js
ig.baked=true;ig.module('game.entities.textBoxAnimation').requires('impact.entity').defines(function(){EntitytextBoxAnimation=ig.Entity.extend({size:{x:665,y:447},animSheet:new ig.AnimationSheet('media/end_text_popup.png',665,447),temp:0,init:function(x,y,settings){this.parent(x,y,settings);this.addAnim('score1',1,[0]);this.maxVel.x=500;this.maxVel.y=500;},update:function(){if(this.scaleCount==0){}
else{this.scaleCount=this.scaleCount-2;if(!this.isScaleTrigger)
{this.scaleCountFadeIn=this.scaleCountFadeIn+2;this.setScale(this.scaleCountFadeIn/250,this.scaleCountFadeIn/250);this.pos.x=Math.floor((ig.system.width-this.size.x)/2);this.pos.y=Math.floor((ig.system.height-this.size.y)/2);if(this.scaleCount==250){this.isScaleTrigger=true;}}}
if(this.isScaleTrigger&&this.okTrigger){if(ig.ua.mobile){document.removeEventListener('touchstart');}
DeactivateCursor();if(isCheckScormAvailable()){$('#ok_trigger').css('display','block').bind('click touchstart',function(){isSubmitClick=true;if(typeof setCourseCompleted=='function'&&isCheckScormAvailable())
setCourseCompleted();setTimeout(function(){window.close()},2000);});$('#menu_trigger').css('display','block').bind('click touchstart',function(){window.location.reload(false);});}
else{$('#ok_trigger').css('display','none');$('#menu_trigger').css({'left':'341px','top':'400px','z-index':'1000000','position':'absolute','cursor':'pointer','display':'block'}).bind('click touchstart',function(){window.location.reload(false);});}
this.okTrigger=false;ig.game.isGameCompleted=true;$('#toggleGame').unbind('click touchstart').css({'cursor':'default'});}
this.parent();},okTrigger:true,scaleCountFadeOut:250,scaleCountFadeIn:0,scaleCount:500,isScaleTrigger:false});});

// lib/game/main.js
ig.baked=true;ig.module('game.main').requires('impact.game','game.entities.player','game.entities.ball1','game.entities.ball10','game.entities.foodconsumed10','game.entities.foodconsumed1','game.entities.foodconsumed100','game.entities.busting','game.entities.reward','plugins.scale','game.entities.reward_second','game.entities.endanimation','game.entities.textBoxAnimation').defines(function(){MyGame=ig.Game.extend({canvasCenter:{},score:0,clearColor:null,MinimumNoOfYellowkey:global_score_control.getNumber_Of_Small_balls(),MinimumNoOfPink:global_score_control.getNumber_Of_Big_balls(),NumberOfOne:0,NumberOfTen:0,NumberOfHundred:0,blob_life_min:500,blob_life_max:1500,preRender:true,CurrentLevel:1,grider:0,poolsize:global_score_control.getTotalBalls(),isGameCompleted:false,isfadeOutActivated:false,temp:0,levelDescription:{TotalScore:global_score_control.getTotalScore(),TotalLevel:global_score_control.getTotalLevel(),grandTotal:0,range:global_score_control.getLevelWiseScoreRange(),level:global_score_control.getLevel()},balls:[{animSheet:new ig.AnimationSheet('media/1.png',12,11),worth:global_score_control.getWorth(1),size:{x:12,y:11}},{animSheet:new ig.AnimationSheet('media/10.png',57,50),worth:global_score_control.getWorth(2),size:{x:57,y:50}}],selectedGrid:[],init:function(){this.canvasCenter.x=parseInt(ig.system.canvas.width/2);this.canvasCenter.y=parseInt(ig.system.canvas.height/2);this.temp=new EntityPlayer();ig.input.bind(ig.KEY.MOUSE1,'pull');this.spawnEntity(EntityPlayer,(ig.system.width-this.temp.animSheet.width)/2,(ig.system.height-this.temp.animSheet.height)/2,{name:"player_organism",type:ig.Entity.TYPE.A,collides:ig.Entity.COLLIDES.PASSIVE,checkAgainst:ig.Entity.TYPE.B,bounciness:1});this.spawnEntity(Entitybust,ig.system.width+100,ig.system.height+100,{name:"organism_bust"});for(var i=0;i<this.poolsize;i++){this.checkScreenForSmallFood1();}
$('#canvas_background').css('background','url(media/background.png)');$('#gameTitle').css('display','block');$('#game_info_container').css('display','block');this.GameLogic()},getRandomInt:function(min,max){return Math.floor(Math.random()*(max-min+1))+min;},hideCanvas:function(){$('#canvas').css({'z-index':'0'});$('#overlape_canvas').css({'z-index':'900'});},showCanvas:function(){$('#canvas').css({'z-index':'900'});$('#overlape_canvas').css({'z-index':'0'});},update:function(){this.parent();},checkScreenForSmallFood1:function(){if(ig.game.getEntitiesByType(EntityBall1).length<this.MinimumNoOfYellow){ig.game.entityCreater1(EntityBall1,0,false);return;}
else if(ig.game.getEntitiesByType(EntityBall10).length<this.MinimumNoOfPink){ig.game.entityCreater1(EntityBall10,1,false);return;}
else{ig.game.entityCreater1(EntityBall1,0,false);return;}},checkScreenForSmallFood:function(){if(ig.game.getEntitiesByType(EntityBall1).length<this.MinimumNoOfYellow){if(this.getRandomInt(1,50)%2==0){ig.game.entityCreater1(EntityBall1,0,true);return;}
else{ig.game.entityCreater(EntityBall1,0);return;}}
else if(ig.game.getEntitiesByType(EntityBall10).length<this.MinimumNoOfPink){if(this.getRandomInt(1,50)%2==0){ig.game.entityCreater1(EntityBall10,1,true);return;}
else{ig.game.entityCreater(EntityBall10,1);return;}}
else{ig.game.entityCreater1(EntityBall1,0);return;}},entityCreater1:function(EntityName,a,isInitialScale){var mov=ig.game.getXY();ig.game.selectedGrid.push(mov[2]);var nn=ig.game.spawnEntity(EntityName,mov[0],mov[1],{positionChecker:true,IdIdentifier:ig.game.getRandomId(),animSheet:ig.game.balls[a].animSheet,worth:ig.game.balls[a].worth,size:ig.game.balls[a].size,type:ig.Entity.TYPE.B,gridposition:mov[2],pixcaltype:"B",scaleCount:1,collides:ig.Entity.COLLIDES.PASSIVE,bounciness:1,zIndex:2,checkAgainst:ig.Entity.TYPE.B,init:function(x,y,settings){this.parent(x,y,settings);this.addAnim('idle',1,[0]);var mover=this.getOuterRandomMotion();this.vel.x=mover[0];this.vel.y=mover[1];this.id=++ig.Entity._lastId;this.pos.x=x;this.pos.y=y;}});if(isInitialScale){nn.setScale(.1,.1)
nn.isInitialScale=isInitialScale;}
return nn;},entityCreater:function(EntityName,a){var mov=ig.game.getOutsideXY();ig.game.selectedGrid.push(mov[2]);var nn=ig.game.spawnEntity(EntityName,mov[0],mov[1],{positionChecker:true,IdIdentifier:ig.game.getRandomId(),animSheet:ig.game.balls[a].animSheet,worth:ig.game.balls[a].worth,size:ig.game.balls[a].size,type:ig.Entity.TYPE.B,gridposition:mov[2],pixcaltype:"B",scaleCount:1,collides:ig.Entity.COLLIDES.PASSIVE,bounciness:1,zIndex:2,checkAgainst:ig.Entity.TYPE.B,init:function(x,y,settings){this.parent(x,y,settings);this.addAnim('idle',1,[0]);var mover=this.getInnerRandomMotion();this.vel.x=mover[0];this.vel.y=mover[1];this.id=++ig.Entity._lastId;this.pos.x=x;this.pos.y=y;}});return nn;},draw:function(){ig.system.context.clearRect(0,0,ig.system.realWidth,ig.system.realHeight);this.parent();},touches:function(other){this.parent();},getXY:function(){var flag=true,pp,aa,pl=ig.game.getEntitiesByType('EntityPlayer')[0];if(typeof pl!='undefined'||pl!=null){if(pl!=0){while(flag){pp=this.getRandomInt(0,this.canvasPositionArray.length-1);aa=[this.getRandomInt(this.canvasPositionArray[pp].xMin+10,this.canvasPositionArray[pp].xMax-10),this.getRandomInt(this.canvasPositionArray[pp].yMin+10,this.canvasPositionArray[pp].yMax-10),pp];if(!this.between(aa[0],pl.pos.x,pl.pos.x+pl.size.x)&&!this.between(aa[1],pl.pos.y,pl.pos.y+pl.size.y)&&this.isInSelectedGrid(pp)){flag=false;break;}}
return aa;}}
return[0,0,0];},between:function(x,min,max){return x>=min&&x<=max;},isInSelectedGrid:function(aa){this.temp=ig.game.selectedGrid;for(var i=0;i<this.temp.length;i++){if(this.temp[i]==aa){return false;}}
return true;},getOutsideXY:function(){this.temp=this.getRandomInt(0,this.canvasPositionOutSide.length-1);return[this.getRandomInt(this.canvasPositionOutSide[this.temp].xMin,this.canvasPositionOutSide[this.temp].xMax),this.getRandomInt(this.canvasPositionOutSide[this.temp].yMin,this.canvasPositionOutSide[this.temp].yMax)];},updateGameVariables:function(){ig.game.levelDescription.level[(this.CurrentLevel-1)].score=this.score;textHighlight();document.getElementById('score').innerHTML=numberWithCommas(ig.game.levelDescription.level[(this.CurrentLevel-1)].score);if(this.levelDescription.grandTotal==this.levelDescription.TotalScore){ig.input.unbindAll();if(ig.ua.mobile)
$('#toggleGame').bind('click touchstart',function(event){checkStoporStart(event.target);});document.getElementById('gameTotal').innerHTML=numberWithCommas(ig.game.levelDescription.grandTotal);setTimeout(function(){var temp;temp=ig.game.getEntitiesByType(EntityBall1);if(temp!='undefined'){for(var i=0;i<temp.length;i++){temp[i].kill();}}
temp=ig.game.getEntitiesByType(EntityBall10);if(temp!='undefined'){for(var i=0;i<temp.length;i++){temp[i].kill();}}
var pl=ig.game.getEntitiesByType(EntityPlayer)[0];pl.vel.x=0;pl.vel.y=0;pl.friction={x:0,y:0};pl.isGameEndActivated=true;pl.lastTouch.x=(ig.system.width)/2;pl.lastTouch.y=(ig.system.height)/2;pl.isTouchTrue=true;var angle=pl.customAngleTo(pl.lastTouch);pl.currentAngle=angle;pl.currentSpeed=pl.baseSpeed*2
var x=Math.cos(angle);var y=Math.sin(angle);if(pl.currentSpeed<0&&pl.currentSpeed>1){pl.pos.x=(ig.system.width)/2;pl.pos.y=(ig.system.height)/2;}else{pl.vel.x=x*pl.currentSpeed;pl.vel.y=y*pl.currentSpeed;}},300)
return false;}
else if(this.score==ig.game.levelDescription.level[(this.CurrentLevel-1)].target){var nowScore=ig.game.levelDescription.level[(this.CurrentLevel-1)].target;PlayCollision();ig.game.hideCanvas();ig.input.bind(ig.KEY.MOUSE1);this.temp=ig.game.getEntitiesByType(EntityPlayer)[0];this.levelChanger();var targetReached={"actor":{"id":Setting["actor.id"]},"published":"","generator":{"appId":Setting["generator.appId"]},"target":{"objectType":"game","displayName":Setting["target.displayName"]},"object":{"id":"123","gameLevel":_gameLevel,"objectType":"Play","target":"10"},"verb":"targetReached"};targetReached.object.target=nowScore;targetReached.published=getTimeStamp();if(typeof window.seer!='undefined')
window.seer.activity(targetReached);}
else if(this.score>ig.game.levelDescription.level[(this.CurrentLevel-1)].target)
{this.busting();var targetOverShot={"published":"2013-03-06T15:04:55Z","verb":"targetOverShot","object":{"id":"123","gameLevel":_gameLevel,"objectType":"Play","target":"40","userScore":"45"},"actor":{"id":Setting["actor.id"]},"generator":{"appId":Setting["generator.appId"]},"target":{"objectType":"game","displayName":Setting["target.displayName"]}};targetOverShot.object.target=ig.game.levelDescription.level[(this.CurrentLevel-1)].target;targetOverShot.object.userScore=this.score;targetOverShot.published=getTimeStamp();if(typeof window.seer!='undefined')
window.seer.activity(targetOverShot);}},gameEnd:function(){var pl=ig.game.getEntitiesByType(EntityPlayer)[0];pl.vel.x=0;pl.vel.y=0;var pos=pl.pos;this.temp=ig.game.getEntitiesByType(EntityBall1);if(this.temp!='undefined'){for(var i=0;i<this.temp.length;i++){this.temp[i].kill();}}
this.temp=ig.game.getEntitiesByType(EntityBall10);if(this.temp!='undefined'){for(var i=0;i<this.temp.length;i++){this.temp[i].kill();}}
var ll=new Entityendanimation();pl=ig.game.spawnEntity(Entityendanimation,(ig.system.width-ll.animSheet.width)/2,(ig.system.height-ll.animSheet.height)/2,{});},busting:function(){var ent10=ig.game.getEntitiesByType(EntityBall10);if(ent10.length>0&&ent10.length>ig.game.NumberOfTen){for(var i=0;i<ig.game.NumberOfTen;i++){ent10[i].BustingKillOptionChecked=true;}}
else if(ent10.length<=ig.game.NumberOfTen&&ent10.length>0)
{for(var i=0;i<ent10.length;i++){ent10[i].BustingKillOptionChecked=true;}}
ent10=ig.game.getEntitiesByType(EntityBall1);if(ent10.length>0&&ent10.length>ig.game.NumberOfOne){for(var i=0;i<ig.game.NumberOfOne;i++){ent10[i].BustingKillOptionChecked=true;}}
else if(ent10.length<=ig.game.NumberOfOne&&ent10.length>0)
{for(var i=0;i<ent10.length;i++){ent10[i].BustingKillOptionChecked=true;}}
this.temp=ig.game.getEntitiesByType(EntityPlayer)[0];this.temp.vel.x=0;this.temp.vel.y=0;if(typeof foodconsumed1!="undefined"){if(foodconsumed1!=0){foodconsumed1.vel.x=0;foodconsumed1.vel.y=0;}}
if(typeof foodconsumed10!="undefined"){if(foodconsumed10!=0){foodconsumed10.vel.x=0;foodconsumed10.vel.y=0;}}
if(typeof foodconsumed100!="undefined"){if(foodconsumed100!=0){foodconsumed100.vel.x=0;foodconsumed100.vel.y=0;}}
var bust=ig.game.getEntitiesByType(Entitybust)[0];bust.pos=this.temp.pos;ig.game.poser=this.temp.pos;this.temp.kill();if(typeof foodconsumed1!="undefined"){if(foodconsumed1!=0){foodconsumed1.pos.x=bust.pos.x+(bust.animSheet.width-foodconsumed1.animSheet.width)/2;foodconsumed1.pos.y=bust.pos.y+(bust.animSheet.height-foodconsumed1.animSheet.height)/2;}}
if(typeof foodconsumed10!="undefined"){if(foodconsumed10!=0){foodconsumed10.pos.x=bust.pos.x+(bust.animSheet.width-foodconsumed10.animSheet.width)/2;foodconsumed10.pos.y=bust.pos.y+(bust.animSheet.height-foodconsumed10.animSheet.height)/2;}}
if(typeof foodconsumed100!="undefined"){if(foodconsumed100!=0){foodconsumed100.pos.x=bust.pos.x+(bust.animSheet.width-foodconsumed100.animSheet.width)/2;foodconsumed100.pos.y=bust.pos.y+(bust.animSheet.height-foodconsumed100.animSheet.height)/2;}}
playIncorrect();bust.currentAnim=bust.changeAnimationSheet(ig.game.levelDescription.level[(ig.game.CurrentLevel-1)].score,bust).rewind();setTimeout(function(){var bust=ig.game.getEntitiesByType(Entitybust)[0];for(var i=0;i<ig.game.NumberOfOne;i++){var pppp=ig.game.entityCreater(EntityBall1,0);pppp.name='hello';pppp.pos.x=bust.pos.x+(bust.size.x/2);pppp.pos.y=bust.pos.y+(bust.size.y/2);pppp.speed=300;var mov=pppp.getBustingRandom();pppp.vel.x=mov[0];pppp.vel.y=mov[1];pppp.update();}
for(var i=0;i<ig.game.NumberOfTen;i++){var pppp=ig.game.entityCreater(EntityBall10,1);pppp.name='hello';pppp.pos.x=bust.pos.x+(bust.size.x/2);pppp.pos.y=bust.pos.y+(bust.size.y/2);pppp.speed=300;var mov=pppp.getBustingRandom();pppp.vel.x=mov[0];pppp.vel.y=mov[1];pppp.update();}
ig.game.killConsumedFoodEntity();setTimeout(function(){var abc=ig.game.getEntitiesByType(EntityBall1);var mov;for(var i=0;i<abc.length;i++){if(abc[i].name=='hello'){abc[i].speed=5;mov=abc[i].getBustingRandom();abc[i].vel.x=mov[0];abc[i].vel.y=mov[1];abc[i].update();}}
abc=ig.game.getEntitiesByType(EntityBall10);for(var i=0;i<abc.length;i++){if(abc[i].name=='hello'){abc[i].speed=5;mov=abc[i].getBustingRandom();abc[i].vel.x=mov[0];abc[i].vel.y=mov[1];abc[i].update();}}},1500);},1100)
setTimeout(function(){var pp=ig.game.getEntitiesByType(Entitybust);for(var i=0;i<pp.length;i++){pp[i].kill();}
ig.game.spawnEntity(EntityPlayer,ig.game.poser.x,ig.game.poser.y,{name:"player_organism"});ig.game.spawnEntity(Entitybust,ig.system.width+100,ig.system.height+100,{name:"organism_bust"});ig.game.levelDescription.grandTotal=ig.game.levelDescription.grandTotal-ig.game.score;ig.game.score=0;ig.game.updateGameVariables();},2500)},killConsumedFoodEntity:function(){if(typeof foodconsumed1!="undefined"){if(foodconsumed1!=0){foodconsumed1.kill();foodconsumed1=0;}}
if(typeof foodconsumed10!="undefined"){if(foodconsumed10!=0){foodconsumed10.kill();foodconsumed10=0;}}
if(typeof foodconsumed100!="undefined"){if(foodconsumed100!=0){foodconsumed100.kill();foodconsumed100=0;}}},recreateGame:function(){this.levelAnimation();},levelChanger:function(){this.isfadeOutActivated=true;this.selectedGrid.length=0;this.CurrentLevel++;this.recreateGame();},cleanScreen:function(){this.temp=ig.game.getEntitiesByType(EntityBall1);if(this.temp!='undefined'){for(var i=0;i<this.temp.length;i++){this.temp[i].kill();}}
this.temp=ig.game.getEntitiesByType(EntityBall10);if(this.temp!='undefined'){for(var i=0;i<this.temp.length;i++){this.temp[i].kill();}}
this.temp=ig.game.getEntitiesByType(EntityPlayer)
if(this.temp!='undefined'){for(var i=0;i<this.temp.length;i++){this.temp[i].kill();}}},GameLogic:function(){this.initializeHTML();},initializeHTML:function(){this.levelDotsChanger();document.getElementById('target').innerHTML=numberWithCommas(this.levelDescription.level[0].target);document.getElementById('gameTotal').innerHTML=0;document.getElementById('score').innerHTML=0;var targetChanged={"published":"","verb":"targetChanged","object":{"gameLevel":_gameLevel,"previousTarget":"35","target":"50","id":"123","objectType":"Play"},"actor":{"id":Setting["actor.id"]},"generator":{"appId":Setting["generator.appId"]},"target":{"objectType":"game","displayName":Setting["target.displayName"]}};targetChanged.object.previousTarget="";targetChanged.object.target=numberWithCommas(this.levelDescription.level[0].target);targetChanged.published=getTimeStamp();if(typeof window.seer!='undefined')
window.seer.activity(targetChanged);},levelAnimation:function(){setTimeout(function(){playLevelComplete();var pl=ig.game.getEntitiesByType(EntityPlayer)[0];pl.vel.x=0;pl.vel.y=0;var pos=[pl.pos,pl.size];pl.kill();var ll=new Entityreward_two();pl=ig.game.spawnEntity(Entityreward_two,pos[0].x+pos[1].x/2-ll.size.x/2,pos[0].y+pos[1].y/2-ll.size.y/2,{});pl.currentAnim=(pl.changeRewardAnimationSheet(ig.game.score,pl)).rewind();setTimeout(function(){if(typeof foodconsumed10!="undefined"){if(foodconsumed10!=0){foodconsumed10.kill();foodconsumed10=0;}}
if(typeof foodconsumed1!="undefined"){if(foodconsumed1!=0){foodconsumed1.kill();foodconsumed1=0;}}
var pl=ig.game.getEntitiesByType(Entityreward_two)[0];var pos=[pl.pos,pl.size];pl.kill();ig.game.cleanScreen();ig.game.isfadeOutActivated=false;var ll=new Entityreward();ig.game.spawnEntity(Entityreward,pos[0].x+pos[1].x/2-ll.size.x/2,pos[0].y+pos[1].y/2-ll.size.y/2,{});pl=ig.game.getEntitiesByType(Entityreward)[0];pl.currentAnim=(pl.changeRewardAnimationSheet(ig.game.score,pl)).rewind();ig.game.score=0;},500);setTimeout(function(){ig.input.bind(ig.KEY.MOUSE1,'pull');var ll=new EntityPlayer();ig.game.getEntitiesByType(Entityreward)[0].kill();var pp=ig.game.spawnEntity(EntityPlayer,(ig.system.width-ll.animSheet.width)/2,(ig.system.height-ll.animSheet.height)/2,{name:"player_organism"});ig.game.levelDotsChanger();document.getElementById('target').innerHTML=numberWithCommas(ig.game.levelDescription.level[(ig.game.CurrentLevel-1)].target);document.getElementById('gameTotal').innerHTML=numberWithCommas(ig.game.levelDescription.grandTotal);var targetChanged={"published":"","verb":"targetChanged","object":{"gameLevel":_gameLevel,"previousTarget":"35","target":"50","id":"123","objectType":"Play"},"actor":{"id":Setting["actor.id"]},"generator":{"appId":Setting["generator.appId"]},"target":{"objectType":"game","displayName":Setting["target.displayName"]}};targetChanged.object.previousTarget=numberWithCommas(ig.game.levelDescription.level[(ig.game.CurrentLevel-2)].target);targetChanged.object.target=numberWithCommas(ig.game.levelDescription.level[(ig.game.CurrentLevel-1)].target);targetChanged.published=getTimeStamp();if(typeof window.seer!='undefined')
window.seer.activity(targetChanged);ig.game.updateGameVariables();for(var i=0;i<ig.game.poolsize;i++){ig.game.checkScreenForSmallFood1();}
ig.game.showCanvas();},3000);},800);},getRandomId:function(){this.temp="";for(var i=0;i<5;i++)
this.temp+=this.PoolOfRandomStringSelection.charAt(Math.floor(Math.random()*this.PoolOfRandomStringSelection.length));return this.temp;},levelDotsChanger:function(){this.temp=document.getElementsByClassName('common');this.temp[this.CurrentLevel-1].className+=' current_level_selected';this.temp[this.CurrentLevel-1].className.replace('default_selected_level','');for(var i=0;i<(this.CurrentLevel-1);i++){$(this.temp[i]).removeClass('default_selected_level current_level_selected').addClass('passed_level_selected');}},PoolOfRandomStringSelection:'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789',canvasPositionOutSide:[{xMin:0,xMax:100,yMin:-10,yMax:-5},{xMin:101,xMax:200,yMin:-10,yMax:-5},{xMin:201,xMax:300,yMin:-10,yMax:-5},{xMin:301,xMax:400,yMin:-10,yMax:-5},{xMin:401,xMax:500,yMin:-10,yMax:-5},{xMin:501,xMax:600,yMin:-10,yMax:-5},{xMin:601,xMax:700,yMin:-10,yMax:-5},{xMin:701,xMax:800,yMin:-10,yMax:-5},{xMin:790+5,xMax:790+10,yMin:-10,yMax:100},{xMin:790+5,xMax:790+10,yMin:101,yMax:200},{xMin:790+5,xMax:790+10,yMin:201,yMax:300},{xMin:790+5,xMax:790+10,yMin:301,yMax:400},{xMin:790+5,xMax:790+10,yMin:401,yMax:500},{xMin:790+5,xMax:790+10,yMin:501,yMax:600},{xMin:0,xMax:100,yMin:600,yMax:600+10},{xMin:101,xMax:200,yMin:600,yMax:600+10},{xMin:201,xMax:300,yMin:600,yMax:600+10},{xMin:301,xMax:400,yMin:600,yMax:600+10},{xMin:401,xMax:500,yMin:600,yMax:600+10},{xMin:501,xMax:600,yMin:600,yMax:600+10},{xMin:601,xMax:700,yMin:600,yMax:600+10},{xMin:701,xMax:800,yMin:600,yMax:600+10},{xMin:-30,xMax:1,yMin:0,yMax:100},{xMin:-30,xMax:1,yMin:101,yMax:200},{xMin:-30,xMax:1,yMin:201,yMax:300},{xMin:-30,xMax:1,yMin:301,yMax:400},{xMin:-30,xMax:1,yMin:401,yMax:500},{xMin:-30,xMax:1,yMin:501,yMax:600}],canvasPositionArray:[{xMin:0,xMax:100,yMin:0,yMax:116},{xMin:101,xMax:200,yMin:0,yMax:116},{xMin:201,xMax:300,yMin:0,yMax:116},{xMin:301,xMax:400,yMin:0,yMax:116},{xMin:401,xMax:500,yMin:0,yMax:116},{xMin:501,xMax:600,yMin:0,yMax:116},{xMin:601,xMax:700,yMin:0,yMax:116},{xMin:701,xMax:800,yMin:0,yMax:116},{xMin:801,xMax:900,yMin:0,yMax:116},{xMin:901,xMax:980,yMin:0,yMax:116},{xMin:10,xMax:100,yMin:116,yMax:232},{xMin:101,xMax:200,yMin:116,yMax:232},{xMin:201,xMax:300,yMin:116,yMax:232},{xMin:301,xMax:400,yMin:116,yMax:232},{xMin:401,xMax:500,yMin:116,yMax:232},{xMin:501,xMax:600,yMin:116,yMax:232},{xMin:601,xMax:700,yMin:116,yMax:232},{xMin:701,xMax:800,yMin:116,yMax:232},{xMin:801,xMax:900,yMin:116,yMax:232},{xMin:901,xMax:980,yMin:116,yMax:232},{xMin:10,xMax:100,yMin:232,yMax:348},{xMin:101,xMax:200,yMin:232,yMax:348},{xMin:201,xMax:300,yMin:232,yMax:348},{xMin:301,xMax:400,yMin:232,yMax:348},{xMin:401,xMax:450,yMin:232,yMax:348},{xMin:550,xMax:600,yMin:232,yMax:348},{xMin:601,xMax:700,yMin:232,yMax:348},{xMin:701,xMax:800,yMin:232,yMax:348},{xMin:10,xMax:100,yMin:348,yMax:580},{xMin:101,xMax:200,yMin:348,yMax:580},{xMin:201,xMax:300,yMin:348,yMax:580},{xMin:301,xMax:400,yMin:348,yMax:580},{xMin:401,xMax:500,yMin:348,yMax:580},{xMin:501,xMax:600,yMin:348,yMax:580},{xMin:601,xMax:700,yMin:348,yMax:580},{xMin:701,xMax:800,yMin:348,yMax:580}]});ig.main('#canvas',MyGame,60,788,600,1);});