ig.module(
    'game.entities.ball10'
)
    .requires(
    'impact.entity'
  //, 'plugins.perpixel'
)
    .defines(function () {
        EntityBall10 = ig.Entity.extend({
            type:ig.Entity.TYPE.B,
            pixcaltype:"B",
            collides:ig.Entity.COLLIDES.PASSIVE,
            size:{x:57, y:50},
            animSheet:new ig.AnimationSheet('media/10.png', 57, 50),
            bounciness:1,
            mass:2,
            zIndex:2,
            life:300,
            worth:global_score_control.getWorth(2),
			radius:27,
            BustingKillOptionChecked:false,
            temp:0,//a temporary variable that can be used for temporary manipulation
            speed:7,   colision:true,
            checkAgainst:ig.Entity.TYPE.BOTH,
            init:function (x,y,settings) {
                this.parent(x, y, settings);
                this.addAnim('idle', 1, [0]);
                this.temp=this.getRandomMovement();
                 this.vel.x=this.temp[0];
                 this.vel.y=this.temp[1];
            },
            /*Custom methods to identifying the angle between two coordinates.*/

            customAngleTo:function (cord) {
                return Math.atan2((cord.y) - (this.pos.y + this.size.y / 2),
                    (cord.x) - (this.pos.x + this.size.x / 2));
            },
            /*Custom methods to identifying the distance between two coordinates.*/

            customDistanceTo:function (other) {
                this.temp = (this.pos.x + this.size.x / 2) - (other.x );
                var yd = (this.pos.y + this.size.y / 2) - (other.y);
                return Math.sqrt(this.temp * this.temp + yd * yd);
            },
            check:function (other) {
                if ((other.pixcaltype == "A")) {
                    return false;
                }else{
                  
                    other.collides = ig.Entity.COLLIDES.ACTIVE;
                }
                this.parent();
            },
            collideWith:function (other, axis) {
                other.collides = ig.Entity.COLLIDES.PASSIVE;
           },
            update:function () {
		                if (this.checkPosition()) {
                        ig.game.selectedGrid.erase(this.gridposition);
                        //ig.game.MinimumNoOfYellow=5
                        this.kill();
						delete this;
                        ig.game.checkScreenForSmallFood();
                        }
                if(ig.game.isfadeOutActivated || this.BustingKillOptionChecked){
                    if(this.scalecount==0){
                ig.game.selectedGrid.erase(this.gridposition);                    
				   this.kill();
						delete this;
                        ig.game.isfadeOutActivated=false;
                    }else if(this.scalecount%7==0){
                        this.setScale(this.scalecount/70,this.scalecount/70);
                    }
                    this.scalecount--;
                }
                  if(this.isInitialScale){
                    if(this.growCounter==45){
                        this.isInitialScale=false;
                        this.setScale(1,1);
                    }else{
                        this.growCounter++;
                        this.initialScaleValue=this.initialScaleValue+0.02;
                        this.setScale(this.initialScaleValue,this.initialScaleValue);
                    }
                }
                this.parent();
            },
            scalecount:70,
            initialScaleValue:0.1,
            isInitialScale:false,
            growCounter:0,
            getRandomMovement:function () {
             this.temp = this.customAngleTo(ig.game.canvasCenter)   //this.getRandomInt(this.angleLowerLimit,this.angleUpperLimit);
                var x = Math.cos(this.temp);
                var y = Math.sin(this.temp);
                return [x * this.speed, y * this.speed];
            },	getBustingRandom:function(){
				 var randomSelection=Math.round(Math.random()*3);
		
				var randomDirection;      
		  switch(randomSelection){
			case 0:
			randomDirection={'x':0,'y':0};
			break;
				case 1:
			randomDirection={'x':ig.system.width,'y':0};
			break;
				case 2:
			randomDirection={'x':0,'y':ig.system.height};
			break;
				case 3:
			randomDirection={'x':ig.system.width,'y':ig.system.height};
			break;
			}
			this.temp = this.customAngleTo(randomDirection)//this.getRandomInt(this.angleLowerLimit,this.angleUpperLimit);
			//  this.temp = this.customAngleTo(ig.game.canvasCenter)//this.getRandomInt(this.angleLowerLimit,this.angleUpperLimit);
                var x = Math.cos(this.temp-ig.game.getRandomInt(0, Math.PI));
                var y = Math.sin(this.temp-ig.game.getRandomInt(0, Math.PI));
                return [x * this.speed, y * this.speed];
			},

            getRandomInt:function (min, max) {
                return Math.floor(Math.random() * (max - min + 1)) + min;
            },
            getInnerRandomMotion:function () {
               this.temp = this.customAngleTo([ig.game.getRandomInt(0, 1000), ig.game.getRandomInt(0, 580)])//this.getRandomInt(this.angleLowerLimit,this.angleUpperLimit);
                var x = Math.cos(this.temp - ig.game.getRandomInt(0, Math.PI));
                var y = Math.sin(this.temp - ig.game.getRandomInt(0, Math.PI));
                return [x * this.speed, y * this.speed];
            }, getOuterRandomMotion:function(){
                this.temp = this.customAngleTo([ig.game.canvasCenter.x+this.getRandomInt(0,50),ig.game.canvasCenter.y+this.getRandomInt(0,50)])//this.getRandomInt(this.angleLowerLimit,this.angleUpperLimit);
                var x = Math.cos(this.temp);
                var y = Math.sin(this.temp);
                return [x * this.speed, y * this.speed];
            },
            checkPosition:function () {
                if (this.pos.x < -100 || this.pos.x > ig.system.width + 50 || this.pos.y < -100 || this.pos.y > ig.system.height + 50) {
                    return true;
                }
            },
          //  MaxLimit:10,
          //  MinLimit:-10
        });
    });