ig.module('game.entities.player')
    .requires('impact.entity')
    .defines(function () {
        EntityPlayer = ig.Entity.extend({
		  type:ig.Entity.TYPE.A,
		   collides:ig.Entity.COLLIDES.PASSIVE,
		     checkAgainst:ig.Entity.TYPE.B, // Check Against B - our evil enemy group
            lastVel:{},
            other:{},
            lastTouch:{},
            isTouchTrue:false,
            isFirstEaten:false,
            size:{x:177,y:180},
            currentSpeed:50,
            createEntity:{type:0, check:false},
            baseSpeed:35,
            currentAngle:0,
            animSheet:new ig.AnimationSheet('media/Animation2_new.png',177, 180),
           //    animSheet:new ig.AnimationSheet('media/Animation2_90.png',161, 159),
            temp:0,//Temporary variable for storing storing instant data.
            bounciness:1,
            isEatingInProgress:false,
            zIndex:1000,
            pixcaltype:"A",
            isTenEaten:false,
            killer:0,
			increamentvalue:0,
			allowlongpress:true,
			friction:{x:20,y:20},
			accel:{x:0,y:0},
			radius:[12,15,17,19,20,22,24,27,30,35,39,40,45,50,54,56,63,68],
		       framesizearray:[{xi:77,yi:78,xf:101,yf:102},{xi:73,yi:75,xf:104,yf:104},{xi:71,yi:73,xf:108,yf:105},{xi:70,yi:70,xf:110,yf:106},{xi:70,yi:68,xf:111,yf:108},
                {xi:68,yi:66,xf:112,yf:110},{xi:65,yi:64,xf:114,yf:114},{xi:61,yi:62,xf:115,yf:116},{xi:59,yi:60,xf:120,yf:120},{xi:55,yi:54,xf:122,yf:125},
                {xi:49,yi:51,xf:127,yf:128},{xi:46,yi:50,xf:128,yf:130},{xi:44,yi:43,xf:131,yf:134},{xi:36,yi:40,xf:140,yf:138},{xi:34,yi:34,xf:141,yf:143},
                {xi:32,yi:32,xf:143,yf:145},{xi:23,yi:25,xf:150,yf:151},{xi:20,yi:20,xf:156,yf:157}],
            isGameEndActivated:false,
            init:function (x, y, settings) {
                this.parent(x, y, settings);
                this.addAnim('idle1', 0.2, [7]);
                this.addAnim('eating1', 0.2, [2,3,4,5,6,7], true);
				this.addAnim('eating2', 0.2, [10,11,12,13,14], true);
				this.addAnim('eating3', 0.2,[17,18,19,20,21], true);
                this.addAnim('eating4', 0.2, [24,25,26,27,28], true);
                this.addAnim('eating5', 0.2, [31,32,33,34,35], true);
                this.addAnim('eating6', 0.2, [36,37,38,39,40,41,42], true);
				this.addAnim('eating7', 0.2, [43,44,45,46,47,48,49], true);
                this.addAnim('eating8', 0.2, [50,51,52,53,54,55,56], true);
				this.addAnim('eating9', 0.2, [57,58,59,60,61,62,63], true);
                this.addAnim('eating10', 0.2, [64,65,66,67,68,69,70], true);
                this.addAnim('eating20', 0.2, [71,72,73,74,75,76,77], true);
                this.addAnim('eating30', 0.2,[78,79,80,81,82,83,84], true);
                this.addAnim('eating40', 0.2, [85,86,87,88,89,90,91], true);
                this.addAnim('eating50', 0.2, [92,93,94,95,96,97,98], true);
                this.addAnim('eating60', 0.2, [99,100,101,102,103,104,105], true);
                this.addAnim('eating70', 0.2, [106,107,108,109,110,111,112], true);
                this.addAnim('eating80', 0.2, [113,114,115,116,117,118,119], true);
                this.addAnim('eating90', 0.2, [120,121,122,123,124,125,126],true);
                this.vel.x = 0;
                this.vel.y = 0;
                this.maxVel.x = 1000;
                this.maxVel.y = 1000;
                },
                update:function () {
                if (ig.input.pressed('pull')) {
                   //then figure the angle
		    this.increamentvalue=0;
		    this.allowlongpress=true;
                    this.lastTouch.x = ig.input.mouse.x;
                    this.lastTouch.y = ig.input.mouse.y;
                    this.isTouchTrue = true;
		    var tile = this.currentAnim.tile;
					var index=parseInt(tile/7);
					if(index == (tile/7)){
					index--;
				    }
				  if(this.customDistanceTo({x:ig.input.mouse.x,y:ig.input.mouse.y})<=this.radius[index]){
				  this.vel.x=0;
				  this.vel.y=0;
				  //this.parent();
					// this.setFoodConsumedObject(); 
				  //return false;
		    }else{
		    this.isTouchTrue=true;
                    var angle = this.customAngleTo(this.lastTouch);
                    this.currentAngle=angle;
                    this.currentSpeed =  this.baseSpeed * parseInt(Math.round(this.customDistanceTo(this.lastTouch )/100,0));
                    var x = Math.cos(angle);
                    var y = Math.sin(angle);
                    this.vel.x = x *  this.currentSpeed;// * ig.system.tick;
                    this.vel.y = y * this.currentSpeed;//  * ig.system.tick;
			  }
		    this.setFoodConsumedObject();              
		  }
			  if(ig.input.state('pull')){
			  if(this.allowlongpress){
			    var tile = this.currentAnim.tile;
			    var index=parseInt(tile/7);
			    if(index == (tile/7)){
			    index--;		         
		    }
			  
		    if(Math.round(this.customDistanceTo(this.lastTouch)>this.radius[index])){
		    var angle = this.customAngleTo(this.lastTouch);
                    this.currentAngle=angle;
                    this.currentSpeed =  this.baseSpeed * (parseInt(Math.round(this.customDistanceTo(this.lastTouch )/100,0))+ this.increamentvalue);
					this.increamentvalue +=0.15;
                    var x = Math.cos(angle);
                    var y = Math.sin(angle);
                    this.vel.x = x *  this.currentSpeed;// * ig.system.tick;
                    this.vel.y = y * this.currentSpeed;//  * ig.system.tick;
			            }else{
					 this.vel.x = 0;
                    this.vel.y = 0;
                    }					
				//	this.setFoodConsumedObject();
					this.boundaryBounce(1);
					
				}else{
				 this.boundaryBounce(2);
				}
			  }else{
			   this.boundaryBounce(2);
			  }

						if(this.isGameEndActivated){
                        if(ig.game.between(this.pos.x+(this.size.x/2),(ig.system.width/2)-2,(ig.system.width/2)+2) && ig.game.between(this.pos.y+(this.size.y/2),(ig.system.height/2)-2,(ig.system.height/2)+2))
                        {	
							playGameComplete();
                           	this.isGameEndActivated=false;
                            this.vel.x=0;
                            this.vel.y=0;
							this.pos.x=(ig.system.width-this.animSheet.width)/2;
                            this.pos.y=(ig.system.height- this.animSheet.height)/2;
                            ig.game.gameEnd();
                     }
                    }
             this.pushBackPlayer();
	//this.setFoodConsumedObject();
				this.parent();
            },
			
            setFoodConsumedObject : function(){
                if (typeof foodconsumed10 != "undefined" && foodconsumed10!=0) {
                   foodconsumed10.pos.x = this.pos.x + Math.floor(((this.size.x - foodconsumed10.size.x) / 2));
                   foodconsumed10.pos.y = this.pos.y + Math.floor(((this.size.y - foodconsumed10.size.y) / 2));
                }
                if (typeof foodconsumed1 != "undefined" && foodconsumed1!=0) {
                   foodconsumed1.pos.x = this.pos.x + Math.floor(((this.size.x - foodconsumed1.size.x) / 2));
                   foodconsumed1.pos.y = this.pos.y + Math.floor(((this.size.y - foodconsumed1.size.y) / 2));
                }
                if (typeof foodconsumed100 != "undefined" && foodconsumed100!=0) {
                   foodconsumed100.pos.x = this.pos.x + Math.floor(((this.size.x - foodconsumed100.size.x) / 2));
                   foodconsumed100.pos.y = this.pos.y + Math.floor(((this.size.y - foodconsumed100.size.y) / 2));
                }
            },
            /*Custom methods to identifying the angle between two coordinates.*/
            customAngleTo:function (cord) {
                return Math.atan2((cord.y) - (this.pos.y + this.size.y / 2),
                    (cord.x) - (this.pos.x + this.size.x / 2));
            },
            /*Custom methods to identifying the distance between two coordinates.*/
            customDistanceTo:function (other) {
                this.temp = (this.pos.x + this.size.x / 2) - (other.x );
                var yd = (this.pos.y + this.size.y / 2) - (other.y);
                return Math.floor(Math.sqrt(this.temp* this.temp + yd * yd));
            },
               getRandomInt:function (min, max) {
                return Math.floor(Math.random() * (max - min + 1)) + min;
            },
            check:function (other) {
        	var tile = this.currentAnim.tile;			
			var boolvalue=false;
				if( typeof other.radius != "undefined" &&  typeof this.radius != "undefined" ){
				   var tile = this.currentAnim.tile;
		          var index=parseInt(tile/7);
		          if(index == (tile/7)){
		         index--;
		          }
				  radius1=other.radius;
				  radius2=this.radius[index]; 
				  if(this.distanceTo(other) >= (radius1+radius2))
				  {
				  boolvalue=true;
				  }
                  }	
               if(boolvalue){}
                else {
                    if(!other.colision){
                       
                        return;
                    }
              
              	 if(tile%7!=0){
                       return;
                    }


     setTimeout(function () {

                        var globInteraction = {
                            "published": "2013-03-06T15:04:55Z",
                            "verb": "globInteraction",
                            "object": {
                                "id": "123",
                                "gameLevel": _gameLevel,
                                "objectType": "Play",
                                "placeValue": "10",
                                "resultValue": "20"
                            },
                            "actor": {
                                "id": Setting["actor.id"]
                            },
                            "generator": {"appId": Setting["generator.appId"]},
                            "target": {
                                "objectType": "game",
                                "displayName": Setting["target.displayName"]
                            }
                        };

                        /*data captures*/
                        globInteraction.object.placeValue = EatenGlobsList.toString();
                        globInteraction.object.resultValue = ScoreAfterEaten.toString();

                        globInteraction.published = getTimeStamp();
//globInteraction=JSON.stringify(globInteraction); 
                        if (typeof window.seer != 'undefined')
                            window.seer.activity(globInteraction);
                        /*data captures complete*/
                    }, 1);
									
					
			EatenGlobsList=other.worth;	/*variable having all collecting globs by player*/
			ScoreAfterEaten=ig.game.score+other.worth; /*variable having all scores after collecting globs by player*/
			if((ig.game.score+other.worth)==ig.game.levelDescription.level[(ig.game.CurrentLevel-1)].target ||(ig.game.levelDescription.grandTotal+parseInt(other.worth))==ig.game.levelDescription.TotalScore)
            {ig.game.hideCanvas();
             ig.input.unbind(ig.KEY.MOUSE1);
             }

			if((ig.game.levelDescription.grandTotal+parseInt(other.worth))==ig.game.levelDescription.TotalScore){
			     if(ig.ua.mobile)
			     document.addEventListener('touchstart',function(e){e.preventDefault();},false);
			   
			   }
                   this.lastVel.x = this.vel.x;
                   this.lastVel.y = this.vel.y;
                   this.vel.y = 0;
                   this.vel.x = 0;
				   this.allowlongpress=false;
                  // this.isEatingInProgress=true;
                    
                    PlayCollision();//Method used for sound file..
					
                    ig.game.selectedGrid.erase(other.gridposition);
					
                    ig.game.levelDescription.grandTotal=parseInt(other.worth)+ig.game.levelDescription.grandTotal;
                
                    ig.game.score = parseInt(other.worth) + ig.game.score;  //Adding the colliding worth in main score

                    if (ig.game.NumberOfOne == 9 && (other.worth/global_score_control.multiplicationFactor)== 1) {
                        this.isFirstEaten = true;
                    }
                    if(ig.game.NumberOfTen==9 && (other.worth/ global_score_control.multiplicationFactor)==10){
                        this.isTenEaten=true;
                    }
								
                     this.updateScoreVariables();
                     this.temp=this.animationSheetChanger(ig.game.score,this);
                     this.currentAnim = this.temp.rewind();
                     other.kill();
						delete other;
					
					   setTimeout(function(){
				            var ply = ig.game.getEntityByName("player_organism");
                                if(typeof ply!='undefined' && ply!=null && ply!='undefined'){
                                    ply.pushBackPlayer();
					           }
                            },1000);
		                setTimeout(function () {
                            var ply = ig.game.getEntityByName("player_organism");
                            if(typeof ply!='undefined' && ply!=null && ply!='undefined'){
                            if (ply.createEntity.check) {
                            if (ply.createEntity.type == 10) {
                            ply.checkforCreation(10);
                            }else if (ply.createEntity.type == 1) {
                            ply.checkforCreation(1);
                            }
                            else if (ply.createEntity.type == 100) {
                            ply.checkforCreation(100);
                            }
                        }

                            }
                  }, 600);

                    if (ig.game.score > 0) {
                        /*Start:logic for checking for food item of worth 10*/
                        if (ig.game.NumberOfTen > 0) {
                            if (typeof foodconsumed10 == "undefined" || foodconsumed10 == 0) {
                                this.createEntity.check = true;
                                this.createEntity.type = 10;
                                 } else {
                                /*Ends*/
                                 foodconsumed10.zIndex = 10;
                                 foodconsumed10.currentAnim = this.switchScoreAnimationSheet(ig.game.NumberOfTen, foodconsumed10);
                                foodconsumed10.pos.x = this.pos.x + Math.floor(((this.size.x - foodconsumed10.size.x) / 2)) ;
                                foodconsumed10.pos.y = this.pos.y + Math.floor(((this.size.y - foodconsumed10.size.y) / 2)) ;
                        }
                       }
                    /*Ends:/

                     /*Start:logic for checking for food item of worth 10*/
                        if (ig.game.NumberOfOne > 0) {
                           if (typeof foodconsumed1 == 'undefined' || foodconsumed1 == 0) {
                            this.createEntity.type = 1;
                                this.createEntity.check = true;
                            }
                            else {
                                foodconsumed1.zIndex = 100;
                                foodconsumed1.currentAnim = this.switchScoreAnimationSheet(ig.game.NumberOfOne, foodconsumed1);
                               foodconsumed1.pos.x = this.pos.x + Math.floor(((this.size.x - foodconsumed1.size.x) / 2));
                               foodconsumed1.pos.y = this.pos.y + Math.floor(((this.size.y - foodconsumed1.size.y) / 2));
                           }
                        }
                        if(ig.game.NumberOfHundred>0){
                            if (typeof foodconsumed100 == 'undefined' || foodconsumed100 == 0) {
                                this.createEntity.type = 1;
                                this.createEntity.check = true;
                            }
                            else {
                                 foodconsumed100.zIndex = 1;
                                 foodconsumed100.pos.x = this.pos.x + Math.floor(((this.size.x - foodconsumed100.size.x) / 2));
                                foodconsumed100.pos.y = this.pos.y + Math.floor(((this.size.y - foodconsumed100.size.y) / 2));

                            }
                        }
                       else if (ig.game.NumberOfOne == 0 &&  this.isFirstEaten){
                            if (typeof foodconsumed1 != 'undefined' || foodconsumed1 != 0) {
                                foodconsumed1.kill();
								delete foodconsumed1;
                                foodconsumed1 = 0;
                                this.isFirstEaten=false;
                            }
                        }
                        if (ig.game.NumberOfTen == 0 && this.isTenEaten){
                           if (typeof foodconsumed10 != 'undefined' ||  foodconsumed10!= 0){
                                foodconsumed10.kill();
								delete foodconsumed10;
                                foodconsumed10 = 0;
                               this.isTenEaten=false;
                               this.createEntity.type = 100;
                               this.createEntity.check = true;

                            }
                        }
                    }

                   ig.game.updateGameVariables();
                    ig.game.checkScreenForSmallFood();
                }
                this.parent();
            },
            collideWith:function (other, axis) {
                this.collides = ig.Entity.COLLIDES.PASSIVE;
                this.setFoodConsumedObject();
            },
            animationSheetChanger:function(number,obj){
                var ab=number/ global_score_control.multiplicationFactor;
                switch (ab) {
                    case 1:
                        return obj.anims.eating1;
                        break;
                    case 2:
                        return obj.anims.eating2;
                        break;
                    case 3:
                        return obj.anims.eating3;
                        break;
                    case 4:
                        return obj.anims.eating4;
                        break;
                    case 5:
                        return obj.anims.eating5;
                        break;
                    case 6:
                        return obj.anims.eating6;
                        break;
                    case 7:
                        return obj.anims.eating7;
                        break;
                    case 8:
                        return obj.anims.eating8;
                        break;

                    case 9:
                        return obj.anims.eating9;
                        break;

                    case 10:case 11:  case 12:case 13:  case 14:case 15:  case 16:case 17:  case 18:case 19:
                        return obj.anims.eating10;
                    break;

                    case 20:  case 21:  case 22:case 23:  case 24:case 25:  case 26:case 27:  case 28:case 29:
                        return obj.anims.eating20;
                        break;

                    case 30:case 31:  case 32:case 33: case 34:case 35: case 36: case 37:  case 38:case 39:
                        return obj.anims.eating30;
                        break;

                    case 40:case 41:  case 42:case 43:  case 44:case 45:  case 46:case 47:  case 48:case 49:
                        return obj.anims.eating40;
                        break;

                    case 50:case 51:  case 52:case 53:  case 54:case 55:  case 56:case 57:  case 58:case 59:
                        return obj.anims.eating50;
                        break;

                    case 60:case 61:  case 62:case 63:  case 64:case 65:  case 66:case 67:  case 68:case 69:
                        return obj.anims.eating60;
                        break;

                    case 70:case 71:  case 72:case 73:  case 74:case 75:  case 76:case 77:  case 78:case 79:
                        return obj.anims.eating70;
                        break;

                    case 80:case 81:  case 82:case 83:  case 84:case 85:  case 86:case 87:  case 88:case 89:
                        return obj.anims.eating80;
                        break;

                    case 90:case 91:  case 92:case 93:  case 94:case 95:  case 96:case 97:  case 98:case 99:
                        return obj.anims.eating90;
                        break;

                       default:
                        return obj.anims.eating1;
                }
            },
            switchScoreAnimationSheet:function (number, obj) {
         
                switch (number) {
                    case 1:
                        return obj.anims.score1;
                        break;
                    case 2:
                        return obj.anims.score2;
                        break;
                    case 3:
                        return obj.anims.score3;
                        break;
                    case 4:
                        return obj.anims.score4;
                        break;
                    case 5:
                        return obj.anims.score5;
                        break;
                    case 6:
                        return obj.anims.score6;
                        break;
                    case 7:
                        return obj.anims.score7;
                        break;
                    case 8:
                        return obj.anims.score8;
                        break;
                    case 9:
                        return obj.anims.score9;
                        break;
                    default:
                        return obj.anims.score1;
                }
            },
		boundaryBounce:function(flag){
			
          if(this.pos.x <= 0 )
           {
			var tile = this.currentAnim.tile;
		    var index=parseInt(tile/7);
		    if(index == (tile/7)){
		    index--;
		    }
			if(this.pos.x <= -(this.framesizearray[index].xi)){
                    
                        var other={pos :{x:this.pos.x,y:this.pos.y},vel :{x:0,y:0},size :{x:0,y:0}};
                        var week=this;
                        ig.Entity.seperateOnXAxis(other,this,week);
						if(flag == 1){
						this.pushBackPlayer();
					this.allowlongpress=false;
				}
                        this.setFoodConsumedObject();
				}
                }
                if(this.pos.x+this.size.x >= ig.system.width)
                {
		        var tile = this.currentAnim.tile;
		       var index=parseInt(tile/7);
		       if(index == (tile/7)){
		       index--;
		       }
                    if(this.pos.x+this.size.x >=(ig.system.width+(this.size.x-this.framesizearray[index].xf))){
                        var other={	pos :{x:this.pos.x+this.size.x,y:this.pos.y},vel :{x:0,y:0},size :{x:0,y:0}};
                        var week=this;
                        ig.Entity.seperateOnXAxis(this,other,week);
				 		if(flag == 1 && this.allowlongpress){
						this.pushBackPlayer();
					   this.allowlongpress=false;
				}
				this.pushBackPlayer();
                this.setFoodConsumedObject();
                    }
               }
                if( this.pos.y <= 0 )
                {
				  var tile = this.currentAnim.tile;
		          var index=parseInt(tile/7);
		          if(index == (tile/7)){
		         index--;
		          }
                   if( this.pos.y <=  -(this.framesizearray[index].yi) )
                     {
                      //  this.pos.y=0;
                        var other={pos :{x:this.pos.x,y:this.pos.y},vel :{x:0,y:0},size :{x:0,y:0}}
                        var week=this;
                        ig.Entity.seperateOnYAxis(other,this,week);
						if(flag == 1){
						this.pushBackPlayer();
					this.allowlongpress=false;
				}      
				
                        this.setFoodConsumedObject();
                    }
                }
                if(  this.pos.y+this.size.y >= ig.system.height )
                {
				 var tile = this.currentAnim.tile;
		          var index=parseInt(tile/7);
		          if(index == (tile/7)){
		         index--;
		          }
                     if(  this.pos.y+this.size.y >= (ig.system.height+(this.size.y-this.framesizearray[index].yf)) )
                    {  
                       // this.pos.y=ig.system.height
                        var other={pos :{x:this.pos.x,y:this.pos.y+this.size.y},vel :{x:0,y:0},size :{x:0,y:0}}
                        var week=this;
                        ig.Entity.seperateOnYAxis(this,other,week);
						if(flag == 1){
						this.pushBackPlayer();
					this.allowlongpress=false;
				}
                        this.setFoodConsumedObject();
							
				
                    }
                }
			
			},
			pushBackPlayer:function(){
			  var ply = ig.game.getEntityByName("player_organism");
                       if(typeof ply!='undefined' && ply!=null && ply!='undefined'){
                           var tile = ply.currentAnim.tile;
                           var index=parseInt(tile/7);
                           if(index == (tile/7)){
                               index--;
                           }

                           if(ply.pos.x <= 0 )
                            {    
                               var tile = ply.currentAnim.tile;
                               var index=parseInt(tile/7);
                               if(index == (tile/7)){
                                   index--;
                               }
                               if(ply.pos.x <= -(ply.framesizearray[index].xi)){
                               //top changes
                                ply.pos.x=   -(ply.size.x/2-ply.radius[index])+15
                                //ply.framesizearray[index].xi) ;
                                ply.setFoodConsumedObject();
                         }
                      }
                        if(ply.pos.x+ply.size.x>= ig.system.width)
                        {
                                var tile = ply.currentAnim.tile;
                                var index=parseInt(tile/7);
                                if(index == (tile/7)){
                                   index--;
                                }
                               if(ply.pos.x+ply.size.x >=(ig.system.width+(ply.size.x-ply.framesizearray[index].xf))){
                                 
                                   // ply.pos.x=ig.system.width;
                                   ply.pos.x=   ig.system.width-(ply.size.x/2+ply.radius[index])-15;//framesizearray[index].xf) ;
                                   ply.setFoodConsumedObject();
                                }
                           }
                           if( ply.pos.y <= 0 )
                           {
                               var tile = ply.currentAnim.tile;
                               var index=parseInt(tile/7);
                               if(index == (tile/7)){
                                   index--;
                               }
                               if( ply.pos.y <=  -(ply.framesizearray[index].yi) )
                               {
                                    //top changes
                                    ply.pos.y=  -( ply.size.y/2 -ply.radius[index])+15; //ply.framesizearray[index].yi) ;
                                    ply.setFoodConsumedObject();
                               }
                           }
                           if( ply.pos.y+ply.size.y >= ig.system.height)
                           {
                               var tile = ply.currentAnim.tile;
                               var index=parseInt(tile/7);
                               if(index == (tile/7)){
                                   index--;
                               }
                               if(  ply.pos.y+ply.size.y >= (ig.system.height+(ply.size.y-ply.framesizearray[index].yf)) )
                               { 
                                   ply.pos.y=  ig.system.height-(ply.size.y/2+ply.radius[index])-15;//ply.framesizearray[index].yf);
                                   ply.setFoodConsumedObject();
                               }
                           }
                       }
			},
            checkforCreation:function(number){
                if (number==10) {
                    foodconsumed10 = ig.game.spawnEntity(EntityFoodConsumed10, this.pos.x, this.pos.y, {name:"foodconsumed10"});
                    foodconsumed10.zIndex = 10;
                    ig.game.sortEntitiesDeferred();
                    foodconsumed10.pos.x = this.pos.x + Math.floor(((this.size.x - foodconsumed10.size.x) / 2));
                    foodconsumed10.pos.y = this.pos.y + Math.floor(((this.size.y - foodconsumed10.size.y) / 2));
            }
                else if (number == 1) {
                    foodconsumed1 = ig.game.spawnEntity(EntityFoodConsumed1, this.pos.x, this.pos.y, {name:"foodconsumed1"});
                    foodconsumed1.zIndex = 100;
                    ig.game.sortEntitiesDeferred();
                    foodconsumed1.pos.x = this.pos.x + Math.floor(((this.size.x - foodconsumed1.size.x) / 2));
                    foodconsumed1.pos.y = this.pos.y + Math.floor(((this.size.y - foodconsumed1.size.y) / 2));
                }
                else if (number == 100) {
                   foodconsumed100 = ig.game.spawnEntity(EntityFoodConsumed100, this.pos.x, this.pos.y, {name:"foodconsumed100"});
                    foodconsumed100.zIndex = 5;
                    ig.game.sortEntitiesDeferred();
                    foodconsumed100.pos.x = this.pos.x + Math.floor(((this.size.x - foodconsumed100.size.x) / 2));
                    foodconsumed100.pos.y = this.pos.y + Math.floor(((this.size.y - foodconsumed100.size.y) / 2));
                }
                this.createEntity.check = false;
                },

            updateScoreVariables:function(){
       
                ig.game.NumberOfHundred=parseInt(ig.game.score/global_score_control.worth_maximum_limit_ball);
                ig.game.NumberOfTen=parseInt((ig.game.score-(ig.game.NumberOfHundred*global_score_control.worth_maximum_limit_ball))/global_score_control.worth_big_ball);
                ig.game.NumberOfOne=parseInt((ig.game.score-(ig.game.NumberOfHundred*global_score_control.worth_maximum_limit_ball+ig.game.NumberOfTen*global_score_control.worth_big_ball))/global_score_control.worth_small_ball);
       
            }

        });
    });