let currentStep = 1;
let language = 'en';

$(document).ready(function () {
  startTimer();

  init();
});

function init() {
  initSCORM();
  showStep(1);
  createAudioTags();
  setListTerms();
  setTerm(0, true);
  setLanguage('en', 0);

  // Construct Create Card modal
  constructCreateCard();
}

function initSCORM() {
  scorm.version = "1.2";
  callSucceeded = scorm.init();
}

/**
 * Show step 
 */
function showStep(n) {

  let visible = $('.step:visible').data('step');

  if (typeof n === 'string') {
    switch (n) {
      case 'next':
        if (visible < data.steps.length) {
          n = ++visible;
        } else {
          return false;
        }
        break;
      case 'back':
        if (visible > 1) {
          n = --visible;
        } else {
          return false;
        }
        break;
    }
  }
  showLoader();
  currentStep = n;
  let $step = $('#step' + n);
  let $siblings = $step.siblings();

  updateCounter(n);
  $siblings.addClass('hidden');
  $step.removeClass('hidden');
  let number = typeof visible !== 'undefined' ? visible - 1 : n - 1;

  for (let prop in data.steps[number]) {
    let $prop = $step.find('.' + prop);
    if ($prop.size()) {
      $prop.text(data.steps[number][prop]);
    }
  }
}

/**
 * Set language by user
 */
function setLanguage(lng, index) {
  language = lng;
  let $display = $('#step2 .lessonCardsContainer .display').first();
  let $btnLanguage = $display.find('.btnLenguage').first();
  let $labelTerm = $display.find('.label-term').first();
  let $labelDefinition = $display.find('.label-definition').first();

  switch (language) {
    case 'es':
      $btnLanguage.text('View English').attr('onclick', "setLanguage('en', " + index + ")");
      $labelTerm.text('Término: ');
      $labelDefinition.text('Definición: ');
      break;
    case 'en':
    default:
      $btnLanguage.text('View Spanish').attr('onclick', "setLanguage('es', " + index + ")");
      $labelTerm.text('Term: ');
      $labelDefinition.text('Definition: ');
      break;
  }


  setListTerms();
  setTerm(index, false);
}

/**
 * Set card properties at index
 */
function setTerm(index, animate) {
  stopAudioAll();
  let $step2 = $('#step2').first();
  let $lessonCards = $step2.find('.lessonCardsContainer');
  let $myCards = $step2.find('.myCardsContainer');
	
  if (!$lessonCards.hasClass('hidden')) {
    setTermLessonCards(index, animate);
  } else if (!$myCards.hasClass('hidden')) {
    setTermMyCards(index, animate);
  }
}

/**
 * Set termn when is lessonCard.
 */
function setTermLessonCards(index, animate) {
  if (!index) {
    index = 0;
  }
  
  setValueNotes(index);
  let card = data.steps[1].lessonCards[index];
  let $display = $('#step2 .lessonCardsContainer .display').first();
  let $image = $display.find('.image').first();
  let $term = $display.find('.term').first();
  let $definition = $display.find('.definition').first();
  let $termAudio = $display.find('.termAudio').first();
  let $definitionAudio = $display.find('.definitionAudio').first();
  let $btnLanguage = $display.find('.btnLenguage').first();
  let $btnNotes = $display.find('button.btnNotes');

  let $btnBackCard = $('#cardList button.backCard').first();
  let $btnNextCard = $('#cardList button.nextCard').first();
  
  switch (language) {
    case 'es':
      $btnLanguage.attr('onclick', "setLanguage('en', " + index + ")");
      break;
    case 'en':
    default:
      $btnLanguage.attr('onclick', "setLanguage('es', " + index + ")");
      break;
  }
  if (animate) {
    $display.fadeOut(0).fadeIn(1000);
  }

  $image.attr('src', './images/' + card.image);
  $term.text(card[language].term.text);
  $definition.text(card[language].definition.text);
  $termAudio.attr('data-audio-id', 'audio_' + index + '_term');
  $definitionAudio.attr('data-audio-id', 'audio_' + index + '_definition');
  $btnNotes.attr('onclick', 'toggleNotes(' + index + ')');

  $btnBackCard.attr('onclick', 'setTerm(' + (index - 1) + ')');
  if (index == 1) {
    $btnBackCard.attr('onclick', 'setTerm(' + (data.steps[1].lessonCards.length - 1) + ')');
  }

  $btnNextCard.attr('onclick', 'setTerm(' + (index + 1) + ')');
  if (index == (data.steps[1].lessonCards.length - 1)) {
    $btnBackCard.attr('onclick', 'setTerm(0)');
  }
}

/**
 * 
 */
function setTermMyCards(index, animate) {
  let $display = $('#step2 .myCardsContainer .display').first();
  let $image = $display.find('.image').first();
  let $term = $display.find('.term').first();
  let $definition = $display.find('.definition').first();
  let $notes = $display.find('.notes');

  let $btnEdit = $display.find('.editMyCard').first();
  let $btnDelete = $display.find('.deleteMyCard').first();

  let card = {
    image: '',
    term: '',
    definition: '',
    notes: ''
  };

  if (data.steps[1].myLessionCards[index]) {
    card = data.steps[1].myLessionCards[index];
  } 
  
  $image.addClass('hidden');
  if (card.image.length) {
    $image.attr('src', './images/' + card.image).removeClass('hidden');
  }

  $term.text(card.term);
  $definition.text(card.definition);
  $notes.text(card.notes);

  $btnEdit.attr('onclick', 'editMyCard(' + index + ')');
  $btnDelete.attr('onclick', 'modalDeleteMyCard(' + index + ')');
}

/**
 * Play audio
 */
function playAudio(element) {
  stopAudioAll();
  let $element = $(element);
  let audioId = $element.attr('data-audio-id');
  let $audio = $('#' + audioId + '_' + language).first();
  $audio[0].play();
}

/**
 * Stop All 
 */
function stopAudioAll() {
  let $audios = $('audio');
  $audios.each(function (index, audio) {
    audio.pause();
    audio.currentTime = 0;
  });
}

/**
 * Construct list cards terms
 */
function setListTerms(type) {
  let $listTerms = $('#step2 .listTerms').first();
  let $html = $('<ul></ul>').addClass('list-group');

  let list = {};
  switch (type) {
    case 'myCards':
    $.each(data.steps[1].myLessionCards, function (i, element) {
      let $strong = $('<strong></strong>').text(element.term);
      let $li = $('<li></li>').addClass('list-group-item bg-color-default pointer').attr('onclick', 'setTerm(' + i + ', true)').html($strong);
      $html.append($li);
    });
      break;
    case 'lessionCards':
    default:
      $.each(data.steps[1].lessonCards, function (i, element) {
        let $strong = $('<strong></strong>').text(element[language].term.text);
        let $li = $('<li></li>').addClass('list-group-item bg-color-default pointer').attr('onclick', 'setTerm(' + i + ', true)').html($strong);
        $html.append($li);
      });
      break;
  }

  $listTerms.html($html);
}

/**
 * 
 */
function showTestMe(e) {
  e.preventDefault();
  e.stopPropagation();

  let $div = $('.testMe').first();
  let size = 380;
  if ($div.height() > 0) {
    size = 0;
  }

  $div.animate({
    height: size + 'px'
  }, 1000);
}

/**
 * Use to show loader for one second.
 */
function showLoader() {
  let $loader = $('#loader');
  $loader.fadeIn().delay(500).fadeOut();
}

/**
 * Generate source audio
 */
function createAudioTags() {
  let $body = $('body');

  $.each(data.steps[1].lessonCards, function (index, item) {
    let $audioTermEn = $('<audio></audio>')
      .attr('id', 'audio_' + index + '_term_en')
      .attr('src', './audio/en/' + item.en.term.audio);
    let $audioTermEs = $('<audio></audio>')
      .attr('id', 'audio_' + index + '_term_es')
      .attr('src', './audio/es/' + item.es.term.audio);

    let $audioDefinitionEn = $('<audio></audio>')
      .attr('id', 'audio_' + index + '_definition_en')
      .attr('src', './audio/en/' + item.en.definition.audio);
    let $audioDefinitionEs = $('<audio></audio>')
      .attr('id', 'audio_' + index + '_definition_es')
      .attr('src', './audio/es/' + item.es.definition.audio);

    $body.append($audioTermEn);
    $body.append($audioTermEs);

    $body.append($audioDefinitionEn);
    $body.append($audioDefinitionEs);
  });
}

/**
 * 
 */
function updateCounter(step) {
  $counter = $('#sidebarContainer .counter').first();

  $counter.html(step + '<br />of<br />' + data.steps.length);
}

/**
 * Set value saved at notes.
 */
function setValueNotes(index) {
  let $textarea = $('#step2 .lessonCardsContainer .display textarea[name=notes]');
  $textarea.val(data.steps[1].lessonCards[index].notes);
}

/**
 * Toggle disabled textarea notes
 */
function toggleNotes(index) {
  let $display = $('#step2 .lessonCardsContainer .display')
  let $button = $display.find('button.btnNotes');
  let $textarea = $display.find('textarea[name=notes]');
  let text = $button.html();

  if ($textarea.prop('disabled')) {
    text = text.replace('Add Notes', 'Save Notes');
    $textarea.prop('disabled', false);
  } else {
    data.steps[1].lessonCards[index].notes = $textarea.val();
    $textarea.prop('disabled', true);
    text = text.replace('Save Notes', 'Add Notes');
  }

  $button.html(text);
}

/**
 * Function for switch between myCards and LessonCards.
 */
function toggleCards(type) {  
  let $step2 = $('#step2');
  let $myCards = $step2.find('.myCardsContainer');
  let $lessionCards = $step2.find('.lessonCardsContainer');

  switch (type) {
    case 'myCards':
      $myCards.removeClass('hidden');
      $lessionCards.addClass('hidden');
      break;

    case 'lessionCards':
    default:
      $lessionCards.removeClass('hidden');
      $myCards.addClass('hidden');
      break;
  }
  setListTerms(type);
  setTerm(0, true);
}