let timeline = [];
let hidden = 1;

/**
 * Create test
 */
function testMe() {
    let $div = $('#step2 .testMe');
    let $form = $div.find('form.testMeForm');
    let $initTest = $div.find('.initFormTestMe');
    let $exec = $div.find('.testExec');
    let $hideInput = $form.find('input[name=hide]:checked').first();
    let $displayInput = $form.find('input[name=display]:checked').first();

    if (!$hideInput.size() || !$displayInput.size()) {
        return false;
    }
    
    if ($displayInput.val == 1) {
        timeline = randomize();
    } else {
        for (let i = 0; i < data.steps[1].lessonCards.length; i++) {
            timeline.push(i);
        }
    }

    hidden = $hideInput.val();

    $initTest.addClass('hidden');
    $exec.removeClass('hidden');
    showTestCard();
}

/**
 * Randomize
 */
function randomize() {
    let random = [];
    let length = data.steps[1].lessonCards.length;
    
    while(random.length < length) {
        let num = Math.floor(Math.random() * length) + 1;
        
        if (random.indexOf(num) === -1) {
            random.push(num);
        }
    }

    return randomize;
}

/**
 * 
 */
function showTestCard(index) {
    let length = timeline.length;
    let back;
    let next;
    

    if (!index) {
        index = 0;
    }
    let card = data.steps[1].lessonCards[index];

    let $div = $('#step2 .testMe').first();
    let $exec = $div.find('.testExec').first();
    let $initTest = $div.find('.initFormTestMe');
    let $image = $exec.find('img.image').first();
    let $term = $exec.find('.term').first();
    let $definition = $exec.find('.definition').first();
    let $btnShowMe = $exec.find('button.showMe').first();
    let $btnBack = $exec.find('.backCard').first();
    let $btnNext = $exec.find('.nextCard').first();

    if (index >= length) {
        $('#testMe').click();
        $initTest.removeClass('hidden');
        $exec.addClass('hidden');
        return false;
    }
    $term.text(card.en.term.text);
    $definition.text(card.en.definition.text);
    $image.attr('src', './images/' + card.image);

    switch (hidden) {
        case '1':
        case 1:
            $term.addClass('hidden');
            $definition.removeClass('hidden');
            $btnShowMe.text('Show me the Term');
            break;

        case '2':
        case 2:
            $definition.addClass('hidden');
            $term.removeClass('hidden');
            $btnShowMe.text('Show me the Definition');
            break;
    }

    back = index - 1;
    next = index + 1;

    if (index == 0) {
        back = length - 1;
    }

    $btnBack.attr('onclick', 'showTestCard(' + back + ')');
    $btnNext.attr('onclick', 'showTestCard(' + next + ')');

    changeCounterTestMe(index);
}

/**
 * Show me hidden
 */
function showMeHidden() {
    let $div = $('#step2 .testMe').first();
    let $exec = $div.find('.testExec').first();
    let $term = $exec.find('.term').first();
    let $definition = $exec.find('.definition').first();
    
    $term.removeClass('hidden');
    $definition.removeClass('hidden');
}

/**
 * 
 */
function changeCounterTestMe(index) {
    let $div = $('#step2 .testMe').first();
    let $cardsTestCounter = $div.find('.cardsTestCounter').first();

    $cardsTestCounter.text('Card ' + (index + 1) + ' of ' + timeline.length)
}