/**
 * Create card image
 */
function constructCreateCard() {
    constructLisCreateCard();
}

/**
 * Open create card modal
 */
function openCreateCardModal(e) {
    e.stopPropagation();
    setCounterTag();
    if (!(data.steps[1].myLessionCards.length < 10)) {
        alert
    }
    let $modal = $('#modalCreateCard');
    let $form = $modal.find('form.CreateCard');
    let $image = $form.find('img.image').first();
    let $imageInput = $form.find('input[name=image]').first();
    let $termInput = $form.find('textarea[name=term]').first();
    let $definitionInput = $form.find('textarea[name=definition]').first();
    let $notesInput = $form.find('textarea[name=notes]').first();
    let $indexArray = $form.find('input[name=index]').first();

    $modal.modal('show').on('hidden.bs.modal', function() {
        $image.removeAttr('src').addClass('hidden');
        $imageInput.val('');
        $termInput.val('');
        $definitionInput.val('');
        $notesInput.val('');
        
        if ($indexArray.size()){
            $indexArray.remove();
        }
    });
}

/**
 * Construct list my cards
 */
function constructLisCreateCard() {
    let $modal = $('#modalCreateCard');
    let $listContent = $modal.find('.listContent > div').first();

    $.each(data.steps[1].cards.images, function(index, item) {
        let $img = $('<img />')
            .addClass('image img-response pointer')
            .attr('src', './images/' + item)
            .attr('onclick', 'setImageNewCard(\'' + item + '\');');
        $listContent.append($img);
    });
}

/**
 * Update counter on change step view.
 */
function setCounterTag() {
    let $modal = $('#modalCreateCard');
    let $cardsCounter = $modal.find('.cardsCounter').first();
    let card = 10;
    if (data.steps[1].myLessionCards.length < 10) {
        card = data.steps[1].myLessionCards.length + 1;
    }
    
    $cardsCounter.text("Card " + card + ' of 10');
}

/**
 * Save card, new or edit.
 */
function saveCard() {
    let $modal = $('#modalCreateCard');
    let $form = $modal.find('form.createCard');
    let $imageInput = $form.find('input[name=image]').first();
    let $termInput = $form.find('textarea[name=term]').first();
    let $definitionInput = $form.find('textarea[name=definition]').first();
    let $notesInput = $form.find('textarea[name=notes]').first();
    let $indexArray = $form.find('input[name=index]').first();
    let indexShow = null;
    let newCard = {
        image: $imageInput.val(),
        term: $termInput.val(),
        definition: $definitionInput.val(),
        notes: $notesInput.val()
    }

    if ($indexArray.size()) {
        indexShow = $indexArray.val();
        data.steps[1].myLessionCards[indexShow] = newCard;
    } else {
        data.steps[1].myLessionCards.push(newCard);
        indexShow = data.steps[1].myLessionCards.length - 1;
    }

    $modal.modal('hide');
    toggleCards('myCards');
    setTerm(indexShow, true);
}

/**
 * Asignar imagen
 */
function setImageNewCard(img) {
    let $form = $('#modalCreateCard form.createCard');
    let $image = $form.find('.image');
    let $imageInput = $form.find('[name=image]');
    
    $image.attr('src', './images/' + img).removeClass('hidden');
    $imageInput.val(img)
}

/**
 * Edit my card
 */
function editMyCard(index) {
    let card = data.steps[1].myLessionCards[index];
    let $modal = $('#modalCreateCard');
    let $form = $modal.find('form.createCard');

    let $image = $form.find('img.image').first();
    let $imageInput = $form.find('input[name=image]').first();
    let $termInput = $form.find('textarea[name=term]').first();
    let $definitionInput = $form.find('textarea[name=definition]').first();
    let $notesInput = $form.find('textarea[name=notes]').first();
    let $indexArray = $('<input />')
        .attr('name', 'index').val(index)
        .attr('type', 'hidden');
    $form.append($indexArray);
    
    $image.attr('src', './images/' + card.image);
    $imageInput.val(card.image);
    $termInput.val(card.term);
    $definitionInput.val(card.definition);
    $notesInput.val(card.notes);
    $modal.modal('show');
}

/**
 * Modal confirm delete my card
 */
function modalDeleteMyCard(index) {
    let $modal = $('#modalDeleteMyCard');
    $modal.find('button.deleteMyCard').attr('onclick', 'deleteMyCard(' + index + ')');
    $modal.modal('show');
}

/**
 * Delete my card
 */
function deleteMyCard(index) {
    let $modal = $('#modalDeleteMyCard');

    $modal.modal('hide');
    data.steps[1].myLessionCards.splice(index, 1)
    toggleCards('myCards');
}